/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller.display;

import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;

public abstract class AbstractDisplay
implements Display {
    public static final int NOTIFICATION_TIME = 1000;
    protected IHost host;
    protected IMidiOutput output;
    protected int noOfLines;
    protected int noOfCells;
    protected int noOfCharacters;
    protected final String emptyLine;
    protected String notificationMessage;
    protected boolean isNotificationActive;
    protected String[] currentMessage;
    protected String[] message;
    protected String[] cells;

    public AbstractDisplay(IHost host, IMidiOutput output, int noOfLines, int noOfCells, int noOfCharacters) {
        this.host = host;
        this.output = output;
        this.noOfLines = noOfLines;
        this.noOfCells = noOfCells;
        this.noOfCharacters = noOfCharacters;
        StringBuilder sb = new StringBuilder(this.noOfCharacters);
        for (int i = 0; i < this.noOfCharacters; ++i) {
            sb.append(' ');
        }
        this.notificationMessage = this.emptyLine = sb.toString();
        this.isNotificationActive = false;
        this.currentMessage = new String[this.noOfLines];
        this.message = new String[this.noOfLines];
        this.cells = new String[this.noOfLines * this.noOfCells];
    }

    @Override
    public AbstractDisplay setRow(int row, String str) {
        this.message[row] = str;
        return this;
    }

    @Override
    public AbstractDisplay clear() {
        for (int i = 0; i < this.noOfLines; ++i) {
            this.clearRow(i);
        }
        return this;
    }

    @Override
    public AbstractDisplay clearRow(int row) {
        for (int i = 0; i < 4; ++i) {
            this.clearBlock(row, i);
        }
        return this;
    }

    @Override
    public AbstractDisplay clearBlock(int row, int block) {
        int cell = 2 * block;
        this.clearCell(row, cell);
        this.clearCell(row, cell + 1);
        return this;
    }

    @Override
    public AbstractDisplay clearColumn(int column) {
        for (int i = 0; i < this.noOfLines; ++i) {
            this.clearCell(i, column);
        }
        return this;
    }

    @Override
    public AbstractDisplay done(int row) {
        int index = row * this.noOfCells;
        this.message[row] = "";
        for (int i = 0; i < this.noOfCells; ++i) {
            int n = row;
            this.message[n] = this.message[n] + this.cells[index + i];
        }
        return this;
    }

    @Override
    public AbstractDisplay allDone() {
        for (int row = 0; row < this.noOfLines; ++row) {
            this.done(row);
        }
        return this;
    }

    @Override
    public void notify(String message) {
        this.notify(message, false, true);
    }

    @Override
    public void notify(String message, boolean onDisplay, boolean onScreen) {
        if (onScreen) {
            this.host.showNotification(message);
        }
        if (onDisplay) {
            this.notifyOnDisplay(message);
        }
    }

    protected void notifyOnDisplay(String message) {
        int padLength = (this.noOfCharacters - message.length()) / 2 + 1;
        String padding = padLength > 0 ? this.emptyLine.substring(0, padLength) : "";
        this.notificationMessage = (padding + message + padding).substring(0, this.noOfCharacters);
        this.isNotificationActive = true;
        this.flush();
        this.host.scheduleTask(() -> {
            this.isNotificationActive = false;
            this.forceFlush();
        }, 1000L);
    }

    @Override
    public void flush() {
        if (this.isNotificationActive) {
            this.writeLine(0, this.notificationMessage);
            for (int row = 1; row < this.noOfLines; ++row) {
                this.writeLine(row, this.emptyLine);
            }
            return;
        }
        for (int row = 0; row < this.noOfLines; ++row) {
            if (this.currentMessage[row] != null && this.currentMessage[row].equals(this.message[row])) continue;
            this.currentMessage[row] = this.message[row];
            if (this.currentMessage[row] == null) continue;
            this.writeLine(row, this.currentMessage[row]);
        }
    }

    @Override
    public void forceFlush() {
        for (int row = 0; row < this.noOfLines; ++row) {
            this.currentMessage[row] = "";
        }
    }
}

