/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller.color;

public class ColorEx {
    public static final ColorEx BLACK = ColorEx.fromRGB(0, 0, 0);
    public static final ColorEx WHITE = ColorEx.fromRGB(255, 255, 255);
    public static final ColorEx LIGHT_GRAY = ColorEx.fromRGB(182, 182, 182);
    public static final ColorEx GRAY = ColorEx.fromRGB(128, 128, 128);
    public static final ColorEx DARK_GRAY = ColorEx.fromRGB(89, 89, 89);
    public static final ColorEx RED = ColorEx.fromRGB(255, 0, 0);
    public static final ColorEx GREEN = ColorEx.fromRGB(0, 255, 0);
    public static final ColorEx YELLOW = ColorEx.fromRGB(255, 255, 0);
    private static final double FACTOR = 0.7;
    private final double red;
    private final double green;
    private final double blue;

    public ColorEx(double red, double green, double blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public static ColorEx fromRGB(int red, int green, int blue) {
        return new ColorEx((double)red / 255.0, (double)green / 255.0, (double)blue / 255.0);
    }

    public static ColorEx brighter(ColorEx c) {
        double r = c.getRed();
        double g = c.getGreen();
        double b = c.getBlue();
        double i = 0.0130718954248366;
        if (r == 0.0 && g == 0.0 && b == 0.0) {
            return new ColorEx(0.0130718954248366, 0.0130718954248366, 0.0130718954248366);
        }
        if (r > 0.0 && r < 0.0130718954248366) {
            r = 0.0130718954248366;
        }
        if (g > 0.0 && g < 0.0130718954248366) {
            g = 0.0130718954248366;
        }
        if (b > 0.0 && b < 0.0130718954248366) {
            b = 0.0130718954248366;
        }
        return new ColorEx(Math.min(r / 0.7, 1.0), Math.min(g / 0.7, 1.0), Math.min(b / 0.7, 1.0));
    }

    public static ColorEx darker(ColorEx c) {
        return new ColorEx(Math.max(c.getRed() * 0.7, 0.0), Math.max(c.getGreen() * 0.7, 0.0), Math.max(c.getBlue() * 0.7, 0.0));
    }

    public double getRed() {
        return this.red;
    }

    public double getGreen() {
        return this.green;
    }

    public double getBlue() {
        return this.blue;
    }
}

