/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller;

import de.mossgrabers.framework.controller.IValueChanger;

public class DefaultValueChanger
implements IValueChanger {
    private final int upperBound;
    private final int fractionValue;
    private final double slowFractionValue;
    private boolean isSlow;

    public DefaultValueChanger(int upperBound, int fractionValue, double slowFractionValue) {
        this.upperBound = upperBound;
        this.fractionValue = fractionValue;
        this.slowFractionValue = slowFractionValue;
    }

    @Override
    public int getUpperBound() {
        return this.upperBound;
    }

    @Override
    public int getFractionValue() {
        return this.fractionValue;
    }

    @Override
    public double getSlowFractionValue() {
        return this.slowFractionValue;
    }

    @Override
    public void setSpeed(boolean isSlow) {
        this.isSlow = isSlow;
    }

    @Override
    public boolean isSlow() {
        return this.isSlow;
    }

    @Override
    public double calcKnobSpeed(int control) {
        return this.calcKnobSpeed(control, this.isSlow ? this.slowFractionValue : (double)this.fractionValue);
    }

    @Override
    public double calcKnobSpeed(int control, double fractionValue) {
        return (double)(control <= 61 ? control : control - 128) * fractionValue;
    }

    @Override
    public int changeValue(int control, int value) {
        return this.changeValue(control, value, this.isSlow ? this.slowFractionValue : (double)this.fractionValue, this.upperBound);
    }

    @Override
    public int changeValue(int control, int value, double fractionValue, int upperBound) {
        return this.changeValue(control, value, fractionValue, upperBound, 0);
    }

    @Override
    public int changeValue(int control, int value, double fractionValue, int maxParameterValue, int minParameterValue) {
        double speed = this.calcKnobSpeed(control, fractionValue);
        return (int)Math.max(Math.min((double)value + speed, (double)maxParameterValue - 1.0), (double)minParameterValue);
    }

    @Override
    public int toMidiValue(int value) {
        return Math.min(value * 127 / (this.getUpperBound() - 1), 127);
    }

    @Override
    public int toDAWValue(int value) {
        return value * (this.getUpperBound() - 1) / 127;
    }

    @Override
    public int toDisplayValue(int value) {
        return value;
    }

    @Override
    public double toNormalizedValue(int value) {
        return Math.min((double)value / (double)(this.getUpperBound() - 1), 1.0);
    }

    @Override
    public int fromNormalizedValue(double value) {
        return (int)Math.round(value * (double)(this.getUpperBound() - 1));
    }
}

