/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller;

import de.mossgrabers.framework.command.core.ContinuousCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.IControllerSetup;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.view.View;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractControllerSetup<S extends IControlSurface<C>, C extends Configuration>
implements IControllerSetup {
    protected final List<S> surfaces = new ArrayList<S>();
    protected final IHost host;
    protected final ISettingsUI settings;
    protected final ISetupFactory factory;
    protected Scales scales;
    protected IModel model;
    protected C configuration;
    protected ColorManager colorManager;
    protected IValueChanger valueChanger;

    protected AbstractControllerSetup(ISetupFactory factory, IHost host, ISettingsUI settings) {
        this.factory = factory;
        this.host = host;
        this.settings = settings;
    }

    public S getSurface() {
        return (S)((IControlSurface)this.surfaces.get(0));
    }

    public S getSurface(int index) {
        return (S)((IControlSurface)this.surfaces.get(index));
    }

    @Override
    public IModel getModel() {
        return this.model;
    }

    public C getConfiguration() {
        return this.configuration;
    }

    @Override
    public void init() {
        this.configuration.init(this.settings);
        this.createScales();
        this.createModel();
        this.createSurface();
        this.createModes();
        this.createObservers();
        this.createViews();
        this.registerTriggerCommands();
        this.registerContinuousCommands();
        this.host.println("Initialized.");
    }

    @Override
    public void exit() {
        this.configuration.clearSettingObservers();
        for (IControlSurface surface : this.surfaces) {
            surface.shutdown();
        }
        this.host.println("Exited.");
    }

    public void flushSurfaces() {
        for (IControlSurface surface : this.surfaces) {
            surface.flush();
        }
    }

    protected void createScales() {
        this.scales = new Scales(this.valueChanger, 36, 100, 8, 8);
    }

    protected abstract void createModel();

    protected abstract void createSurface();

    protected void createModes() {
    }

    protected void createViews() {
    }

    protected void createObservers() {
    }

    protected void registerTriggerCommands() {
    }

    protected void registerContinuousCommands() {
    }

    protected void addTriggerCommand(Integer commandID, int midiCC, TriggerCommand command) {
        this.addTriggerCommand(commandID, midiCC, command, 0);
    }

    protected void addTriggerCommand(Integer commandID, int midiCC, TriggerCommand command, int deviceIndex) {
        IControlSurface surface = (IControlSurface)this.surfaces.get(deviceIndex);
        surface.getViewManager().registerTriggerCommand(commandID, command);
        surface.assignTriggerCommand(midiCC, commandID);
    }

    protected void addContinuousCommand(Integer commandID, int midiCC, ContinuousCommand command) {
        IControlSurface surface = (IControlSurface)this.surfaces.get(0);
        surface.getViewManager().registerContinuousCommand(commandID, command);
        surface.assignContinuousCommand(midiCC, commandID);
    }

    protected void addNoteCommand(Integer commandID, int midiCC, TriggerCommand command) {
        IControlSurface surface = (IControlSurface)this.surfaces.get(0);
        surface.getViewManager().registerNoteCommand(commandID, command);
        surface.assignNoteCommand(midiCC, commandID);
    }

    protected void createScaleObservers(C conf) {
        conf.addSettingObserver(AbstractConfiguration.SCALES_SCALE, () -> {
            this.scales.setScaleByName(conf.getScale());
            this.updateViewNoteMapping();
        });
        conf.addSettingObserver(AbstractConfiguration.SCALES_BASE, () -> {
            this.scales.setScaleOffsetByName(conf.getScaleBase());
            this.updateViewNoteMapping();
        });
        conf.addSettingObserver(AbstractConfiguration.SCALES_IN_KEY, () -> {
            this.scales.setChromatic(!conf.isScaleInKey());
            this.updateViewNoteMapping();
        });
        conf.addSettingObserver(AbstractConfiguration.SCALES_LAYOUT, () -> {
            this.scales.setScaleLayoutByName(conf.getScaleLayout());
            this.updateViewNoteMapping();
        });
    }

    private void updateViewNoteMapping() {
        for (IControlSurface surface : this.surfaces) {
            View view = surface.getViewManager().getActiveView();
            if (view == null) continue;
            view.updateNoteMapping();
        }
    }
}

