/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.controller.grid.PadGridImpl;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.View;
import de.mossgrabers.framework.view.ViewManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractControlSurface<C extends Configuration>
implements IControlSurface<C> {
    protected static final int BUTTON_STATE_INTERVAL = 400;
    protected IHost host;
    protected C configuration;
    protected ColorManager colorManager;
    protected IMidiOutput output;
    protected IMidiInput input;
    protected ViewManager viewManager = new ViewManager();
    protected ModeManager modeManager = new ModeManager();
    protected int selectButtonId = -1;
    protected int shiftButtonId = -1;
    protected int deleteButtonId = -1;
    protected int soloButtonId = -1;
    protected int muteButtonId = -1;
    protected int leftButtonId = -1;
    protected int rightButtonId = -1;
    protected int upButtonId = -1;
    protected int downButtonId = -1;
    private int[] buttons;
    protected ButtonEvent[] buttonStates;
    private int[] noteVelocities;
    protected boolean[] buttonConsumed;
    private List<int[]> buttonCache;
    protected int[] gridNotes;
    protected Display display;
    protected PadGridImpl pads;
    protected Map<Integer, Map<Integer, Integer>> triggerCommands = new HashMap<Integer, Map<Integer, Integer>>();
    protected Map<Integer, Map<Integer, Integer>> continuousCommands = new HashMap<Integer, Map<Integer, Integer>>();
    protected Map<Integer, Integer> noteCommands = new HashMap<Integer, Integer>();
    private boolean[] gridNoteConsumed;
    private ButtonEvent[] gridNoteStates;
    private int[] gridNoteVelocities;

    public AbstractControlSurface(IHost host, C configuration, ColorManager colorManager, IMidiOutput output, IMidiInput input, int[] buttons) {
        this.host = host;
        this.configuration = configuration;
        this.colorManager = colorManager;
        this.output = output;
        this.input = input;
        if (this.input != null) {
            this.input.setMidiCallback(this::handleMidi);
        }
        this.gridNotes = new int[64];
        this.buttons = buttons;
        this.buttonStates = new ButtonEvent[128];
        this.buttonConsumed = new boolean[128];
        if (this.buttons != null) {
            for (int button : this.buttons) {
                this.buttonStates[button] = ButtonEvent.UP;
                this.buttonConsumed[button] = false;
            }
        }
        this.buttonCache = new ArrayList<int[]>(128);
        for (int i = 0; i < 128; ++i) {
            int[] channels = new int[16];
            Arrays.fill(channels, -1);
            this.buttonCache.add(channels);
        }
        this.noteVelocities = new int[128];
        this.gridNoteConsumed = new boolean[128];
        Arrays.fill(this.gridNoteConsumed, false);
        int size = 64;
        this.gridNoteStates = new ButtonEvent[128];
        this.gridNoteVelocities = new int[128];
        for (int i = 0; i < 64; ++i) {
            this.gridNotes[i] = 36 + i;
            this.gridNoteStates[i] = ButtonEvent.UP;
            this.gridNoteVelocities[i] = 0;
        }
    }

    @Override
    public ViewManager getViewManager() {
        return this.viewManager;
    }

    @Override
    public ModeManager getModeManager() {
        return this.modeManager;
    }

    public int[] getButtons() {
        return this.buttons;
    }

    @Override
    public C getConfiguration() {
        return this.configuration;
    }

    @Override
    public Display getDisplay() {
        return this.display;
    }

    @Override
    public void setDisplay(Display display) {
        this.display = display;
    }

    @Override
    public PadGrid getPadGrid() {
        return this.pads;
    }

    @Override
    public IMidiOutput getOutput() {
        return this.output;
    }

    @Override
    public IMidiInput getInput() {
        return this.input;
    }

    @Override
    public void assignTriggerCommand(int midiCC, Integer commandID) {
        this.assignTriggerCommand(midiCC, 0, commandID);
    }

    @Override
    public void assignTriggerCommand(int midiCC, int midiChannel, Integer commandID) {
        Map<Integer, Integer> channelMap = this.triggerCommands.get(midiCC);
        if (channelMap == null) {
            channelMap = new HashMap<Integer, Integer>();
            this.triggerCommands.put(midiCC, channelMap);
        }
        channelMap.put(midiChannel, commandID);
    }

    @Override
    public Integer getTriggerCommand(int midiCC) {
        return this.getTriggerCommand(midiCC, 0);
    }

    @Override
    public Integer getTriggerCommand(int midiCC, int midiChannel) {
        Map<Integer, Integer> channelMap = this.triggerCommands.get(midiCC);
        return channelMap == null ? null : channelMap.get(midiChannel);
    }

    @Override
    public void assignContinuousCommand(int midiCC, Integer commandID) {
        this.assignContinuousCommand(midiCC, 0, commandID);
    }

    @Override
    public void assignContinuousCommand(int midiCC, int midiChannel, Integer commandID) {
        Map<Integer, Integer> channelMap = this.continuousCommands.get(midiCC);
        if (channelMap == null) {
            channelMap = new HashMap<Integer, Integer>();
            this.continuousCommands.put(midiCC, channelMap);
        }
        channelMap.put(midiChannel, commandID);
    }

    @Override
    public Integer getContinuousCommand(int midiCC) {
        return this.getContinuousCommand(midiCC, 0);
    }

    @Override
    public Integer getContinuousCommand(int midiCC, int midiChannel) {
        Map<Integer, Integer> channelMap = this.continuousCommands.get(midiCC);
        return channelMap == null ? null : channelMap.get(midiChannel);
    }

    @Override
    public void assignNoteCommand(int midiNote, Integer commandID) {
        this.noteCommands.put(midiNote, commandID);
    }

    @Override
    public Integer getNoteCommand(int midiNote) {
        return this.noteCommands.get(midiNote);
    }

    @Override
    public boolean isGridNote(int note) {
        if (this.gridNotes.length > 0) {
            return note >= this.gridNotes[0] && note <= this.gridNotes[this.gridNotes.length - 1];
        }
        return false;
    }

    @Override
    public void setKeyTranslationTable(int[] table) {
        if (this.input == null) {
            return;
        }
        Integer[] t = new Integer[table.length];
        for (int i = 0; i < table.length; ++i) {
            t[i] = table[i];
        }
        this.input.setKeyTranslationTable(t);
    }

    @Override
    public void setVelocityTranslationTable(int[] table) {
        if (this.input == null) {
            return;
        }
        Integer[] t = new Integer[table.length];
        for (int i = 0; i < table.length; ++i) {
            t[i] = table[i];
        }
        this.input.setVelocityTranslationTable(t);
    }

    @Override
    public boolean isSelectPressed() {
        return this.isPressed(this.selectButtonId);
    }

    @Override
    public boolean isShiftPressed() {
        return this.isPressed(this.shiftButtonId);
    }

    @Override
    public boolean isDeletePressed() {
        return this.isPressed(this.deleteButtonId);
    }

    @Override
    public boolean isSoloPressed() {
        return this.isPressed(this.soloButtonId);
    }

    @Override
    public boolean isMutePressed() {
        return this.isPressed(this.muteButtonId);
    }

    @Override
    public boolean isPressed(int button) {
        if (button == -1) {
            return false;
        }
        if (this.buttonStates[button] == null) {
            this.errorln("Unregistered button: " + button);
            return false;
        }
        switch (this.buttonStates[button]) {
            case DOWN: 
            case LONG: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getSelectButtonId() {
        return this.selectButtonId;
    }

    @Override
    public int getDeleteButtonId() {
        return this.deleteButtonId;
    }

    @Override
    public int getMuteButtonId() {
        return this.muteButtonId;
    }

    @Override
    public int getSoloButtonId() {
        return this.soloButtonId;
    }

    @Override
    public int getLeftButtonId() {
        return this.leftButtonId;
    }

    @Override
    public int getRightButtonId() {
        return this.rightButtonId;
    }

    @Override
    public int getUpButtonId() {
        return this.upButtonId;
    }

    @Override
    public int getDownButtonId() {
        return this.downButtonId;
    }

    @Override
    public int getSceneButton(int index) {
        return -1;
    }

    @Override
    public void updateButton(int button, int value) {
        if (this.buttonCache.get(button)[0] == value) {
            return;
        }
        this.setButton(button, value);
        this.buttonCache.get((int)button)[0] = value;
    }

    @Override
    public void updateButtonEx(int button, int channel, int value) {
        if (this.buttonCache.get(button)[channel] == value) {
            return;
        }
        this.setButtonEx(button, channel, value);
        this.buttonCache.get((int)button)[channel] = value;
    }

    @Override
    public void updateButton(int button, String colorID) {
        this.updateButton(button, this.colorManager.getColor(colorID));
    }

    @Override
    public void updateButtonEx(int button, int channel, String colorID) {
        this.updateButtonEx(button, channel, this.colorManager.getColor(colorID));
    }

    @Override
    public void setButton(int button, int state) {
        this.setButtonEx(button, 0, state);
    }

    @Override
    public void setButton(int button, String colorID) {
        this.setButton(button, this.colorManager.getColor(colorID));
    }

    @Override
    public void setButtonEx(int button, int channel, String colorID) {
        this.setButtonEx(button, channel, this.colorManager.getColor(colorID));
    }

    @Override
    public void setButtonEx(int button, int channel, int state) {
    }

    @Override
    public boolean isButton(int cc) {
        return this.buttonStates[cc] != null;
    }

    @Override
    public void setButtonConsumed(int buttonID) {
        this.buttonConsumed[buttonID] = true;
    }

    @Override
    public boolean isButtonConsumed(int buttonID) {
        return this.buttonConsumed[buttonID];
    }

    @Override
    public void flush() {
        this.scheduledFlush();
        this.redrawGrid();
    }

    @Override
    public void shutdown() {
    }

    protected void handleMidi(int status, int data1, int data2) {
        int code = status & 0xF0;
        int channel = status & 0xF;
        switch (code) {
            case 128: 
            case 144: {
                if (this.isGridNote(data1)) {
                    this.handleGridNote(data1, code == 128 ? 0 : data2);
                    break;
                }
                this.handleNoteEvent(data1, code == 128 ? 0 : data2);
                break;
            }
            case 160: {
                View view = this.viewManager.getActiveView();
                if (view == null) break;
                view.executeAftertouchCommand(data1, data2);
                break;
            }
            case 176: {
                this.handleCC(channel, data1, data2);
                break;
            }
            case 208: {
                View view = this.viewManager.getActiveView();
                if (view == null) break;
                view.executeAftertouchCommand(-1, data1);
                break;
            }
            case 224: {
                View view = this.viewManager.getActiveView();
                if (view == null) break;
                view.executePitchbendCommand(channel, data1, data2);
                break;
            }
            default: {
                this.host.println("Unhandled midi status: " + status);
            }
        }
    }

    @Override
    public void scheduleTask(Runnable callback, long delay) {
        this.host.scheduleTask(callback, delay);
    }

    @Override
    public void println(String message) {
        this.host.println(message);
    }

    @Override
    public void errorln(String message) {
        this.host.error(message);
    }

    @Override
    public void sendMidiEvent(int status, int data1, int data2) {
        this.input.sendRawMidiEvent(status, data1, data2);
    }

    protected void handleGridNote(int note, int velocity) {
        ButtonEvent buttonEvent = this.gridNoteStates[note] = velocity > 0 ? ButtonEvent.DOWN : ButtonEvent.UP;
        if (velocity > 0) {
            this.gridNoteVelocities[note] = velocity;
        }
        if (this.gridNoteStates[note] == ButtonEvent.DOWN) {
            this.scheduleTask(() -> this.checkGridNoteState(note), 400L);
        }
        if (this.gridNoteStates[note] == ButtonEvent.UP && this.gridNoteConsumed[note]) {
            this.gridNoteConsumed[note] = false;
            return;
        }
        View view = this.viewManager.getActiveView();
        if (view != null) {
            view.onGridNote(note, velocity);
        }
    }

    private void checkGridNoteState(int note) {
        if (this.gridNoteStates[note] != ButtonEvent.DOWN) {
            return;
        }
        this.gridNoteStates[note] = ButtonEvent.LONG;
        View view = this.viewManager.getActiveView();
        if (view != null) {
            view.onGridNoteLongPress(note);
        }
    }

    public void setGridNoteConsumed(int note) {
        this.gridNoteConsumed[note] = true;
    }

    public int getGridNoteVelocity(int note) {
        return this.gridNoteVelocities[note];
    }

    public int getNoteVelocity(int note) {
        return this.noteVelocities[note];
    }

    protected void handleCC(int channel, int cc, int value) {
        if (this.isButton(cc)) {
            ButtonEvent buttonEvent = this.buttonStates[cc] = value > 0 ? ButtonEvent.DOWN : ButtonEvent.UP;
            if (this.buttonStates[cc] == ButtonEvent.DOWN) {
                this.scheduleTask(() -> this.checkButtonState(cc), 400L);
            }
            if (this.buttonStates[cc] == ButtonEvent.UP && this.buttonConsumed[cc]) {
                this.buttonConsumed[cc] = false;
                return;
            }
        }
        this.handleCCEvent(channel, cc, value);
    }

    protected void handleNoteEvent(int note, int velocity) {
        this.noteVelocities[note] = velocity;
        View view = this.viewManager.getActiveView();
        if (view == null) {
            return;
        }
        Integer commandID = this.getNoteCommand(note);
        if (commandID != null) {
            view.executeNoteCommand(commandID, velocity);
            return;
        }
        this.println("Unsupported Midi Note: " + note);
    }

    protected void handleCCEvent(int channel, int cc, int value) {
        View view = this.viewManager.getActiveView();
        if (view == null) {
            return;
        }
        Integer commandID = this.getTriggerCommand(cc, channel);
        if (commandID != null) {
            ButtonEvent event = this.isButton(cc) ? this.buttonStates[cc] : null;
            view.executeTriggerCommand(commandID, event);
            return;
        }
        commandID = this.getContinuousCommand(cc, channel);
        if (commandID != null) {
            view.executeContinuousCommand(commandID, value);
            return;
        }
        this.println("Unsupported Midi CC: " + cc);
    }

    protected void scheduledFlush() {
        View view = this.viewManager.getActiveView();
        if (view != null) {
            view.updateControlSurface();
        }
        if (this.display != null) {
            this.display.flush();
        }
    }

    protected void redrawGrid() {
        View view = this.viewManager.getActiveView();
        if (view == null) {
            return;
        }
        view.drawGrid();
        if (this.pads != null) {
            this.pads.flush();
        }
    }

    private void checkButtonState(int buttonID) {
        if (this.buttonStates[buttonID] != ButtonEvent.DOWN) {
            return;
        }
        this.buttonStates[buttonID] = ButtonEvent.LONG;
        this.handleCCEvent(0, buttonID, 127);
    }
}

