/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.configuration;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.IIntegerSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.configuration.SettingObserver;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.scale.Scale;
import de.mossgrabers.framework.scale.ScaleLayout;
import de.mossgrabers.framework.scale.Scales;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractConfiguration
implements Configuration {
    public static final Integer SCALES_SCALE = 0;
    public static final Integer SCALES_BASE = 1;
    public static final Integer SCALES_IN_KEY = 2;
    public static final Integer SCALES_LAYOUT = 3;
    public static final Integer ENABLE_VU_METERS = 4;
    public static final Integer BEHAVIOUR_ON_STOP = 5;
    public static final Integer DISPLAY_CROSSFADER = 6;
    public static final Integer FLIP_SESSION = 7;
    public static final Integer LOCK_FLIP_SESSION = 8;
    public static final Integer SELECT_CLIP_ON_LAUNCH = 9;
    public static final Integer DRAW_RECORD_STRIPE = 10;
    public static final Integer CONVERT_AFTERTOUCH = 11;
    public static final Integer ACTIVATE_FIXED_ACCENT = 12;
    public static final Integer FIXED_ACCENT_VALUE = 13;
    public static final Integer QUANTIZE_AMOUNT = 14;
    public static final Integer FLIP_RECORD = 15;
    public static final Integer AUTO_SELECT_DRUM = 16;
    public static final Integer NEW_CLIP_LENGTH = 17;
    public static final Integer TURN_OFF_EMPTY_DRUM_PADS = 18;
    public static final Integer ACTION_FOR_REC_ARMED_PAD = 19;
    public static final Integer FOOTSWITCH_2 = 20;
    public static final Integer BROWSER_DISPLAY_FILTER1 = 21;
    public static final Integer BROWSER_DISPLAY_FILTER2 = 22;
    public static final Integer BROWSER_DISPLAY_FILTER3 = 23;
    public static final Integer BROWSER_DISPLAY_FILTER4 = 24;
    public static final Integer BROWSER_DISPLAY_FILTER5 = 25;
    public static final Integer BROWSER_DISPLAY_FILTER6 = 26;
    public static final Integer BROWSER_DISPLAY_FILTER7 = 27;
    public static final Integer BROWSER_DISPLAY_FILTER8 = 28;
    protected static final String CATEGORY_DRUMS = "Drum Sequencer";
    protected static final String CATEGORY_SCALES = "Scales";
    protected static final String CATEGORY_SESSION = "Session";
    protected static final String CATEGORY_TRANSPORT = "Transport";
    protected static final String CATEGORY_WORKFLOW = "Workflow";
    protected static final String CATEGORY_PADS = "Pads";
    protected static final String CATEGORY_PLAY_AND_SEQUENCE = "Play and Sequence";
    protected static final String CATEGORY_HARDWARE_SETUP = "Hardware Setup";
    protected static final String CATEGORY_DEBUG = "Debug";
    private static final String SCALE_IN_KEY = "In Key";
    private static final String SCALE_CHROMATIC = "Chromatic";
    public static final int FOOTSWITCH_2_TOGGLE_PLAY = 0;
    public static final int FOOTSWITCH_2_TOGGLE_RECORD = 1;
    public static final int FOOTSWITCH_2_STOP_ALL_CLIPS = 2;
    public static final int FOOTSWITCH_2_TOGGLE_CLIP_OVERDUB = 3;
    public static final int FOOTSWITCH_2_UNDO = 4;
    public static final int FOOTSWITCH_2_TAP_TEMPO = 5;
    public static final int FOOTSWITCH_2_NEW_BUTTON = 6;
    public static final int FOOTSWITCH_2_CLIP_BASED_LOOPER = 7;
    public static final int FOOTSWITCH_2_PANEL_LAYOUT_ARRANGE = 8;
    public static final int FOOTSWITCH_2_PANEL_LAYOUT_MIX = 9;
    public static final int FOOTSWITCH_2_PANEL_LAYOUT_EDIT = 10;
    public static final int FOOTSWITCH_2_ADD_INSTRUMENT_TRACK = 11;
    public static final int FOOTSWITCH_2_ADD_AUDIO_TRACK = 12;
    public static final int FOOTSWITCH_2_ADD_EFFECT_TRACK = 13;
    public static final int FOOTSWITCH_2_QUANTIZE = 14;
    private static final String[] AFTERTOUCH_CONVERSION_VALUES = new String[131];
    public static final String[] NEW_CLIP_LENGTH_VALUES;
    private static final String[] BEHAVIOUR_ON_STOP_VALUES;
    private static final String[] ACTIONS_REC_ARMED_PADS;
    protected static final String[] FOOTSWITCH_VALUES;
    private static final String[] BROWSER_FILTER_COLUMN_NAMES;
    private static final String[] COLUMN_VALUES;
    public static final String[] ON_OFF_OPTIONS;
    private IEnumSetting scaleBaseSetting;
    private IEnumSetting scaleInKeySetting;
    private IEnumSetting scaleLayoutSetting;
    private IEnumSetting scaleSetting;
    private IEnumSetting enableVUMetersSetting;
    private IEnumSetting displayCrossfaderSetting;
    private IEnumSetting flipSessionSetting;
    private IEnumSetting lockFlipSessionSetting;
    private IEnumSetting accentActiveSetting;
    private IIntegerSetting accentValueSetting;
    private IIntegerSetting quantizeAmountSetting;
    private IEnumSetting newClipLengthSetting;
    private final Map<Integer, Set<SettingObserver>> observers = new HashMap<Integer, Set<SettingObserver>>();
    protected IValueChanger valueChanger;
    private String scale = "Major";
    private String scaleBase = "C";
    private boolean scaleInKey = true;
    private String scaleLayout = "4th ^";
    private boolean enableVUMeters = false;
    private BehaviourOnStop behaviourOnStop = BehaviourOnStop.MOVE_PLAY_CURSOR;
    protected boolean displayCrossfader = true;
    private boolean flipSession = false;
    private boolean lockFlipSession = false;
    private boolean selectClipOnLaunch = true;
    private boolean drawRecordStripe = true;
    private int convertAftertouch = 0;
    private boolean accentActive = false;
    private int fixedAccentValue = 127;
    private int quantizeAmount = 1;
    private boolean flipRecord = false;
    private int newClipLength = 2;
    private boolean autoSelectDrum = false;
    private boolean turnOffEmptyDrumPads = false;
    private int actionForRecArmedPad = 0;
    private int footswitch2 = 6;
    private boolean[] browserDisplayFilter = new boolean[]{true, true, true, true, true, true, true, true};

    public AbstractConfiguration(IValueChanger valueChanger) {
        this.valueChanger = valueChanger;
    }

    @Override
    public void addSettingObserver(Integer settingID, SettingObserver observer) {
        Set<SettingObserver> settingObservers = this.observers.get(settingID);
        if (settingObservers == null) {
            settingObservers = new HashSet<SettingObserver>();
            this.observers.put(settingID, settingObservers);
        }
        settingObservers.add(observer);
    }

    @Override
    public void clearSettingObservers() {
        this.observers.clear();
    }

    public void setScale(String scale) {
        this.scaleSetting.set(scale);
    }

    @Override
    public String getScale() {
        return this.scale;
    }

    public void setScaleBase(String scaleBase) {
        this.scaleBaseSetting.set(scaleBase);
    }

    @Override
    public String getScaleBase() {
        return this.scaleBase;
    }

    public void setScaleInKey(boolean inScale) {
        this.scaleInKeySetting.set(inScale ? SCALE_IN_KEY : SCALE_CHROMATIC);
    }

    @Override
    public boolean isScaleInKey() {
        return this.scaleInKey;
    }

    public void setScaleLayout(String scaleLayout) {
        this.scaleLayoutSetting.set(scaleLayout);
    }

    @Override
    public String getScaleLayout() {
        return this.scaleLayout;
    }

    @Override
    public void setVUMetersEnabled(boolean enabled) {
        this.setOnOffSetting(this.enableVUMetersSetting, enabled);
    }

    @Override
    public boolean isEnableVUMeters() {
        return this.enableVUMeters;
    }

    public void setDisplayCrossfader(boolean enabled) {
        this.setOnOffSetting(this.displayCrossfaderSetting, enabled);
    }

    @Override
    public void setFlipSession(boolean enabled) {
        this.setOnOffSetting(this.flipSessionSetting, enabled);
    }

    @Override
    public void setAccentEnabled(boolean enabled) {
        this.setOnOffSetting(this.accentActiveSetting, enabled);
    }

    @Override
    public void setAccentValue(int value) {
        this.accentValueSetting.set(value);
    }

    @Override
    public void changeQuantizeAmount(int control) {
        if (this.quantizeAmountSetting != null) {
            this.quantizeAmountSetting.set(this.valueChanger.changeValue(control, this.quantizeAmount, 1.0, 101));
        }
    }

    @Override
    public void setQuantizeAmount(int value) {
        if (this.quantizeAmountSetting != null) {
            this.quantizeAmountSetting.set(value);
        }
    }

    @Override
    public void resetQuantizeAmount() {
        if (this.quantizeAmountSetting != null) {
            this.quantizeAmountSetting.set(100);
        }
    }

    @Override
    public boolean isSelectClipOnLaunch() {
        return this.selectClipOnLaunch;
    }

    protected void setOnOffSetting(IEnumSetting setting, boolean enabled) {
        setting.set(enabled ? ON_OFF_OPTIONS[1] : ON_OFF_OPTIONS[0]);
    }

    @Override
    public BehaviourOnStop getBehaviourOnStop() {
        return this.behaviourOnStop;
    }

    @Override
    public boolean isDisplayCrossfader() {
        return this.displayCrossfader;
    }

    @Override
    public boolean isFlipSession() {
        return this.flipSession;
    }

    @Override
    public int getConvertAftertouch() {
        return this.convertAftertouch;
    }

    @Override
    public boolean isAccentActive() {
        return this.accentActive;
    }

    @Override
    public int getFixedAccentValue() {
        return this.fixedAccentValue;
    }

    @Override
    public int getQuantizeAmount() {
        return this.quantizeAmount;
    }

    @Override
    public boolean isFlipRecord() {
        return this.flipRecord;
    }

    @Override
    public int getNewClipLength() {
        return this.newClipLength;
    }

    @Override
    public void setNewClipLength(int value) {
        this.newClipLengthSetting.set(NEW_CLIP_LENGTH_VALUES[value]);
    }

    @Override
    public boolean isAutoSelectDrum() {
        return this.autoSelectDrum;
    }

    @Override
    public boolean isTurnOffEmptyDrumPads() {
        return this.turnOffEmptyDrumPads;
    }

    @Override
    public boolean isLockFlipSession() {
        return this.lockFlipSession;
    }

    @Override
    public boolean isDrawRecordStripe() {
        return this.drawRecordStripe;
    }

    @Override
    public int getActionForRecArmedPad() {
        return this.actionForRecArmedPad;
    }

    @Override
    public int getFootswitch2() {
        return this.footswitch2;
    }

    public boolean[] getBrowserDisplayFilter() {
        return this.browserDisplayFilter;
    }

    protected void activateScaleSetting(ISettingsUI settingsUI) {
        String[] scaleNames = Scale.getNames();
        this.scaleSetting = settingsUI.getEnumSetting("Scale", CATEGORY_SCALES, scaleNames, scaleNames[0]);
        this.scaleSetting.addValueObserver(value -> {
            this.scale = value;
            this.notifyObservers(SCALES_SCALE);
        });
    }

    protected void activateScaleBaseSetting(ISettingsUI settingsUI) {
        this.scaleBaseSetting = settingsUI.getEnumSetting("Base", CATEGORY_SCALES, Scales.BASES, Scales.BASES[0]);
        this.scaleBaseSetting.addValueObserver(value -> {
            this.scaleBase = value;
            this.notifyObservers(SCALES_BASE);
        });
    }

    protected void activateScaleInScaleSetting(ISettingsUI settingsUI) {
        this.scaleInKeySetting = settingsUI.getEnumSetting(SCALE_IN_KEY, CATEGORY_SCALES, new String[]{SCALE_IN_KEY, SCALE_CHROMATIC}, SCALE_IN_KEY);
        this.scaleInKeySetting.addValueObserver(value -> {
            this.scaleInKey = SCALE_IN_KEY.equals(value);
            this.notifyObservers(SCALES_IN_KEY);
        });
    }

    protected void activateScaleLayoutSetting(ISettingsUI settingsUI) {
        String[] names = ScaleLayout.getNames();
        this.scaleLayoutSetting = settingsUI.getEnumSetting("Layout", CATEGORY_SCALES, names, names[0]);
        this.scaleLayoutSetting.addValueObserver(value -> {
            this.scaleLayout = value;
            this.notifyObservers(SCALES_LAYOUT);
        });
    }

    protected void activateEnableVUMetersSetting(ISettingsUI settingsUI) {
        this.activateEnableVUMetersSetting(settingsUI, CATEGORY_WORKFLOW);
    }

    protected void activateEnableVUMetersSetting(ISettingsUI settingsUI, String category) {
        this.enableVUMetersSetting = settingsUI.getEnumSetting("VU Meters", category, ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        this.enableVUMetersSetting.addValueObserver(value -> {
            this.enableVUMeters = "On".equals(value);
            this.notifyObservers(ENABLE_VU_METERS);
        });
    }

    protected void activateBehaviourOnStopSetting(ISettingsUI settingsUI) {
        IEnumSetting behaviourOnStopSetting = settingsUI.getEnumSetting("Behaviour on Stop", CATEGORY_TRANSPORT, BEHAVIOUR_ON_STOP_VALUES, BEHAVIOUR_ON_STOP_VALUES[0]);
        behaviourOnStopSetting.addValueObserver(value -> {
            this.behaviourOnStop = BehaviourOnStop.values()[AbstractConfiguration.lookupIndex(BEHAVIOUR_ON_STOP_VALUES, value)];
            this.notifyObservers(BEHAVIOUR_ON_STOP);
        });
    }

    protected void activateDisplayCrossfaderSetting(ISettingsUI settingsUI) {
        this.displayCrossfaderSetting = settingsUI.getEnumSetting("Display Crossfader on Track", CATEGORY_WORKFLOW, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.displayCrossfaderSetting.addValueObserver(value -> {
            this.displayCrossfader = "On".equals(value);
            this.notifyObservers(DISPLAY_CROSSFADER);
        });
    }

    protected void activateFlipSessionSetting(ISettingsUI settingsUI) {
        this.flipSessionSetting = settingsUI.getEnumSetting("Flip Session", CATEGORY_SESSION, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.flipSessionSetting.addValueObserver(value -> {
            this.flipSession = "On".equals(value);
            this.notifyObservers(FLIP_SESSION);
        });
    }

    protected void activateLockFlipSessionSetting(ISettingsUI settingsUI) {
        this.lockFlipSessionSetting = settingsUI.getEnumSetting("Lock flip Session", CATEGORY_SESSION, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.lockFlipSessionSetting.addValueObserver(value -> {
            this.lockFlipSession = "On".equals(value);
            this.notifyObservers(LOCK_FLIP_SESSION);
        });
    }

    protected void activateSelectClipOnLaunchSetting(ISettingsUI settingsUI) {
        IEnumSetting selectClipOnLaunchSetting = settingsUI.getEnumSetting("Select clip on launch", CATEGORY_SESSION, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        selectClipOnLaunchSetting.addValueObserver(value -> {
            this.selectClipOnLaunch = "On".equals(value);
            this.notifyObservers(SELECT_CLIP_ON_LAUNCH);
        });
    }

    protected void activateDrawRecordStripeSetting(ISettingsUI settingsUI) {
        IEnumSetting drawRecordStripeSetting = settingsUI.getEnumSetting("Display clips of record enabled tracks in red", CATEGORY_SESSION, ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        drawRecordStripeSetting.addValueObserver(value -> {
            this.drawRecordStripe = "On".equals(value);
            this.notifyObservers(DRAW_RECORD_STRIPE);
        });
    }

    protected void activateActionForRecArmedPad(ISettingsUI settingsUI) {
        IEnumSetting actionForRecArmedPadSetting = settingsUI.getEnumSetting("Action for pressing rec armed empty clip", CATEGORY_SESSION, ACTIONS_REC_ARMED_PADS, ACTIONS_REC_ARMED_PADS[0]);
        actionForRecArmedPadSetting.addValueObserver(value -> {
            this.actionForRecArmedPad = AbstractConfiguration.lookupIndex(ACTIONS_REC_ARMED_PADS, value);
            this.notifyObservers(ACTION_FOR_REC_ARMED_PAD);
        });
    }

    protected void activateConvertAftertouchSetting(ISettingsUI settingsUI) {
        IEnumSetting convertAftertouchSetting = settingsUI.getEnumSetting("Convert Poly Aftertouch to", CATEGORY_PADS, AFTERTOUCH_CONVERSION_VALUES, AFTERTOUCH_CONVERSION_VALUES[1]);
        convertAftertouchSetting.addValueObserver(value -> {
            this.convertAftertouch = AbstractConfiguration.lookupIndex(AFTERTOUCH_CONVERSION_VALUES, value) - 3;
            this.notifyObservers(CONVERT_AFTERTOUCH);
        });
    }

    protected void activateAccentActiveSetting(ISettingsUI settingsUI) {
        this.accentActiveSetting = settingsUI.getEnumSetting("Activate Fixed Accent", CATEGORY_PLAY_AND_SEQUENCE, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.accentActiveSetting.addValueObserver(value -> {
            this.accentActive = "On".equals(value);
            this.notifyObservers(ACTIVATE_FIXED_ACCENT);
        });
    }

    protected void activateAccentValueSetting(ISettingsUI settingsUI) {
        this.accentValueSetting = settingsUI.getRangeSetting("Fixed Accent Value", CATEGORY_PLAY_AND_SEQUENCE, 1, 127, 1, "", 127);
        this.accentValueSetting.addValueObserver(value -> {
            this.fixedAccentValue = value + 1;
            this.notifyObservers(FIXED_ACCENT_VALUE);
        });
    }

    protected void activateFlipRecordSetting(ISettingsUI settingsUI) {
        IEnumSetting flipRecordSetting = settingsUI.getEnumSetting("Flip arranger and clip record / automation", CATEGORY_TRANSPORT, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        flipRecordSetting.addValueObserver(value -> {
            this.flipRecord = "On".equals(value);
            this.notifyObservers(FLIP_RECORD);
        });
    }

    protected void activateNewClipLengthSetting(ISettingsUI settingsUI) {
        this.newClipLengthSetting = settingsUI.getEnumSetting("New Clip Length", CATEGORY_WORKFLOW, NEW_CLIP_LENGTH_VALUES, NEW_CLIP_LENGTH_VALUES[2]);
        this.newClipLengthSetting.addValueObserver(value -> {
            this.newClipLength = AbstractConfiguration.lookupIndex(NEW_CLIP_LENGTH_VALUES, value);
            this.notifyObservers(NEW_CLIP_LENGTH);
        });
    }

    protected void activateQuantizeAmountSetting(ISettingsUI settingsUI) {
        this.quantizeAmountSetting = settingsUI.getRangeSetting("Quantize Amount", CATEGORY_PLAY_AND_SEQUENCE, 1, 100, 1, "%", 100);
        this.quantizeAmountSetting.addValueObserver(value -> {
            this.quantizeAmount = value + 1;
            this.notifyObservers(QUANTIZE_AMOUNT);
        });
    }

    protected void activateAutoSelectDrumSetting(ISettingsUI settingsUI) {
        IEnumSetting autoSelectDrumSetting = settingsUI.getEnumSetting("Auto-select drum settings", CATEGORY_DRUMS, new String[]{"Off", "Channel"}, "Off");
        autoSelectDrumSetting.addValueObserver(value -> {
            this.autoSelectDrum = "Channel".equals(value);
            this.notifyObservers(AUTO_SELECT_DRUM);
        });
    }

    protected void activateTurnOffEmptyDrumPadsSetting(ISettingsUI settingsUI) {
        IEnumSetting turnOffEmptyDrumPadsSetting = settingsUI.getEnumSetting("Turn off empty drum pads", CATEGORY_DRUMS, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        turnOffEmptyDrumPadsSetting.addValueObserver(value -> {
            this.turnOffEmptyDrumPads = "On".equals(value);
            this.notifyObservers(TURN_OFF_EMPTY_DRUM_PADS);
        });
    }

    protected void activateFootswitchSetting(ISettingsUI settingsUI) {
        IEnumSetting footswitch2Setting = settingsUI.getEnumSetting("Footswitch 2", CATEGORY_WORKFLOW, FOOTSWITCH_VALUES, FOOTSWITCH_VALUES[6]);
        footswitch2Setting.addValueObserver(value -> {
            this.footswitch2 = AbstractConfiguration.lookupIndex(FOOTSWITCH_VALUES, value);
            this.notifyObservers(FOOTSWITCH_2);
        });
    }

    protected void activateBrowserSettings(ISettingsUI settingsUI) {
        int i = 0;
        while (i < BROWSER_FILTER_COLUMN_NAMES.length) {
            IEnumSetting browserDisplayFilterSetting = settingsUI.getEnumSetting(BROWSER_FILTER_COLUMN_NAMES[i], "Browser", COLUMN_VALUES, COLUMN_VALUES[1]);
            int index = i++;
            browserDisplayFilterSetting.addValueObserver(value -> {
                this.browserDisplayFilter[index] = COLUMN_VALUES[1].equals(value);
                this.notifyObservers(BROWSER_DISPLAY_FILTER1 + index);
            });
        }
    }

    protected void notifyObservers(Integer settingID) {
        Set<SettingObserver> set = this.observers.get(settingID);
        if (set != null) {
            set.forEach(SettingObserver::call);
        }
    }

    public static int lookupIndex(String[] options, String value) {
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals(value)) continue;
            return i;
        }
        return 0;
    }

    static {
        AbstractConfiguration.AFTERTOUCH_CONVERSION_VALUES[0] = "Off";
        AbstractConfiguration.AFTERTOUCH_CONVERSION_VALUES[1] = "Poly Aftertouch";
        AbstractConfiguration.AFTERTOUCH_CONVERSION_VALUES[2] = "Channel Aftertouch";
        for (int i = 0; i < 128; ++i) {
            AbstractConfiguration.AFTERTOUCH_CONVERSION_VALUES[3 + i] = "CC " + i;
        }
        NEW_CLIP_LENGTH_VALUES = new String[]{"1 Beat", "2 Beat", "1 Bar", "2 Bars", "4 Bars", "8 Bars", "16 Bars", "32 Bars"};
        BEHAVIOUR_ON_STOP_VALUES = new String[]{"Move play cursor", "Return to Zero", "Pause"};
        ACTIONS_REC_ARMED_PADS = new String[]{"Start recording", "Create new clip", "Do nothing"};
        FOOTSWITCH_VALUES = new String[]{"Toggle Play", "Toggle Record", "Stop All Clips", "Toggle Clip Overdub", "Undo", "Tap Tempo", "New Button", "Clip Based Looper", "Panel layout arrange", "Panel layout mix", "Panel layout edit", "Add instrument track", "Add audio track", "Add effect track", "Quantize"};
        BROWSER_FILTER_COLUMN_NAMES = new String[]{"Collection", "Location", "File Type", "Category", "Tags", "Creator", "Device Type", "Device"};
        COLUMN_VALUES = new String[]{"Hide", "Show"};
        ON_OFF_OPTIONS = new String[]{"Off", "On"};
    }

    public static enum BehaviourOnStop {
        MOVE_PLAY_CURSOR,
        RETURN_TO_ZERO,
        PAUSE;

    }
}

