/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.transport;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.utils.ButtonEvent;

public class StopCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    public StopCommand(IModel model, S surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ITransport transport = this.model.getTransport();
        if (transport.isPlaying()) {
            this.handleStopOptions();
        } else {
            transport.stopAndRewind();
        }
    }

    protected void handleStopOptions() {
        ITransport transport = this.model.getTransport();
        switch (this.surface.getConfiguration().getBehaviourOnStop()) {
            case RETURN_TO_ZERO: {
                transport.stopAndRewind();
                break;
            }
            case MOVE_PLAY_CURSOR: {
                transport.play();
                break;
            }
            case PAUSE: {
                transport.stop();
            }
        }
    }
}

