/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.transport;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.utils.ButtonEvent;

public class PlayCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private boolean restartFlag = false;

    public PlayCommand(IModel model, S surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.surface.isSelectPressed()) {
            this.model.getTransport().togglePunchIn();
            return;
        }
        if (this.restartFlag) {
            this.model.getTransport().stopAndRewind();
            this.restartFlag = false;
            return;
        }
        this.handleStopOptions();
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.surface.isSelectPressed()) {
            this.model.getTransport().togglePunchOut();
        } else {
            this.model.getTransport().toggleLoop();
        }
    }

    protected void handleStopOptions() {
        ITransport transport = this.model.getTransport();
        switch (this.surface.getConfiguration().getBehaviourOnStop()) {
            case RETURN_TO_ZERO: {
                if (transport.isPlaying()) {
                    transport.stopAndRewind();
                    break;
                }
                transport.play();
                break;
            }
            case MOVE_PLAY_CURSOR: {
                transport.play();
                this.doubleClickTest();
                break;
            }
            case PAUSE: {
                if (transport.isPlaying()) {
                    transport.stop();
                } else {
                    transport.play();
                }
                this.doubleClickTest();
            }
        }
    }

    private void doubleClickTest() {
        this.restartFlag = true;
        this.surface.scheduleTask(() -> {
            this.restartFlag = false;
        }, 250L);
    }
}

