/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.clip;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;

public class NewCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    public NewCommand(IModel model, S surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.handleExecute(true);
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.handleExecute(false);
        }
    }

    private void handleExecute(boolean enableOverdub) {
        ITrack track = this.model.getSelectedTrack();
        if (track == null) {
            this.surface.getDisplay().notify("Please select an Instrument track first.", true, true);
            return;
        }
        ISlot selectedSlot = track.getSelectedSlot();
        int slotIndex = selectedSlot == null ? 0 : selectedSlot.getIndex();
        ISlot slot = track.getEmptySlot(slotIndex);
        if (slot == null) {
            this.surface.getDisplay().notify("In the current selected grid view there is no empty slot. Please scroll down.", true, true);
            return;
        }
        this.model.createClip(slot, this.getClipLength());
        if (slotIndex != slot.getIndex()) {
            slot.select();
        }
        slot.launch();
        if (enableOverdub) {
            this.model.getTransport().setLauncherOverdub(true);
        }
    }

    protected int getClipLength() {
        return this.surface.getConfiguration().getNewClipLength();
    }
}

