/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.application;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class PaneCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private Panels panel;

    public PaneCommand(Panels panel, IModel model, S surface) {
        super(model, surface);
        this.panel = panel;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        IApplication application = this.model.getApplication();
        switch (this.panel) {
            case NOTE: {
                application.toggleNoteEditor();
                break;
            }
            case AUTOMATION: {
                application.toggleAutomationEditor();
                break;
            }
            case DEVICE: {
                this.model.getCursorDevice().toggleWindowOpen();
                break;
            }
            case MIXER: {
                application.toggleMixer();
            }
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        switch (this.panel) {
            case DEVICE: {
                this.model.getApplication().toggleDevices();
                break;
            }
        }
    }

    public static enum Panels {
        NOTE,
        AUTOMATION,
        DEVICE,
        MIXER;

    }
}

