/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ViewManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ViewMultiSelectCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private List<Integer> viewIds = new ArrayList<Integer>();

    public ViewMultiSelectCommand(IModel model, S surface, Integer ... viewIds) {
        super(model, surface);
        this.viewIds.addAll(Arrays.asList(viewIds));
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ViewManager viewManager = this.surface.getViewManager();
        Integer activeViewId = viewManager.getActiveViewId();
        int index = this.viewIds.indexOf(activeViewId) + 1;
        if (index < 0 || index >= this.viewIds.size()) {
            index = 0;
        }
        viewManager.setActiveView(this.viewIds.get(index));
    }
}

