/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class MoveTrackBankCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private boolean moveLeft;
    private boolean moveBy1;
    private Integer deviceMode;

    public MoveTrackBankCommand(IModel model, S surface, Integer deviceMode, boolean moveBy1, boolean moveLeft) {
        super(model, surface);
        this.deviceMode = deviceMode;
        this.moveBy1 = moveBy1;
        this.moveLeft = moveLeft;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.surface.getModeManager().isActiveMode(this.deviceMode)) {
            if (this.moveBy1) {
                if (this.moveLeft) {
                    this.model.getCursorDevice().previousParameterPage();
                } else {
                    this.model.getCursorDevice().nextParameterPage();
                }
            } else if (this.moveLeft) {
                this.model.getCursorDevice().selectPrevious();
            } else {
                this.model.getCursorDevice().selectNext();
            }
            return;
        }
        if (this.moveBy1) {
            if (this.moveLeft) {
                this.model.getCurrentTrackBank().scrollTracksUp();
            } else {
                this.model.getCurrentTrackBank().scrollTracksDown();
            }
        } else if (this.moveLeft) {
            this.model.getCurrentTrackBank().scrollTracksPageUp();
        } else {
            this.model.getCurrentTrackBank().scrollTracksPageDown();
        }
    }
}

