/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ModeMultiSelectCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private List<Integer> modeIds = new ArrayList<Integer>();

    public ModeMultiSelectCommand(IModel model, S surface, Integer ... modeIds) {
        super(model, surface);
        this.modeIds.addAll(Arrays.asList(modeIds));
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = this.surface.getModeManager();
        Integer activeModeId = modeManager.getActiveModeId();
        int index = this.modeIds.indexOf(activeModeId) + 1;
        if (index < 0 || index >= this.modeIds.size()) {
            index = 0;
        }
        modeManager.setActiveMode(this.modeIds.get(index));
    }
}

