/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;

public class DuplicateCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    public DuplicateCommand(IModel model, S surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        ITrack track = this.model.getSelectedTrack();
        if (track == null || !track.doesExist()) {
            return;
        }
        ISlot slot = track.getSelectedSlot();
        if (slot == null) {
            return;
        }
        boolean isPlaying = slot.isPlaying();
        slot.duplicate();
        if (!isPlaying) {
            return;
        }
        this.model.getHost().scheduleTask(() -> {
            ISlot slotNew = track.getSelectedSlot();
            if (slotNew != null) {
                slotNew.launch();
                return;
            }
            track.scrollClipPageForwards();
            this.model.getHost().scheduleTask(() -> {
                ISlot slotNew2 = track.getSelectedSlot();
                if (slotNew2 != null) {
                    slotNew2.launch();
                }
            }, 200L);
        }, 200L);
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.model.getProject().createSceneFromPlayingLauncherClips();
        }
    }
}

