/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;

public abstract class CursorCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private static final int BUTTON_REPEAT_INTERVAL = 75;
    protected Direction direction;
    protected boolean canScrollLeft;
    protected boolean canScrollRight;
    protected boolean canScrollUp;
    protected boolean canScrollDown;

    public CursorCommand(Direction direction, IModel model, S surface) {
        super(model, surface);
        this.direction = direction;
    }

    @Override
    public void execute(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        switch (this.direction) {
            case LEFT: {
                this.scrollLeft();
                break;
            }
            case RIGHT: {
                this.scrollRight();
                break;
            }
            case UP: {
                this.scrollUp();
                break;
            }
            case DOWN: {
                this.scrollDown();
            }
        }
    }

    public void updateArrows() {
        this.updateArrowStates();
        this.surface.scheduleTask(this::delayedUpdateArrows, 150L);
    }

    protected void delayedUpdateArrows() {
        int buttonOnColor = this.getButtonOnColor();
        int buttonOffColor = this.getButtonOffColor();
        this.surface.updateButton(this.surface.getLeftButtonId(), this.canScrollLeft ? buttonOnColor : buttonOffColor);
        this.surface.updateButton(this.surface.getRightButtonId(), this.canScrollRight ? buttonOnColor : buttonOffColor);
        this.surface.updateButton(this.surface.getUpButtonId(), this.canScrollUp ? buttonOnColor : buttonOffColor);
        this.surface.updateButton(this.surface.getDownButtonId(), this.canScrollDown ? buttonOnColor : buttonOffColor);
    }

    protected int getButtonOffColor() {
        return this.model.getColorManager().getColor("BUTTON_STATE_OFF");
    }

    protected int getButtonOnColor() {
        return this.model.getColorManager().getColor("BUTTON_STATE_ON");
    }

    protected abstract void updateArrowStates();

    protected abstract void scrollLeft();

    protected abstract void scrollRight();

    protected void scrollUp() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        if (this.surface.isShiftPressed()) {
            tb.scrollScenesPageUp();
        } else {
            tb.scrollScenesUp();
        }
    }

    protected void scrollDown() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        if (this.surface.isShiftPressed()) {
            tb.scrollScenesPageDown();
        } else {
            tb.scrollScenesDown();
        }
    }

    protected void scrollTracksLeft() {
        int index;
        ITrack sel = this.model.getSelectedTrack();
        int n = index = sel == null ? 0 : sel.getIndex() - 1;
        if (index == -1 || this.surface.isShiftPressed()) {
            this.scrollTrackBankLeft(sel, index);
            return;
        }
        this.selectTrack(index);
    }

    protected void scrollTrackBankLeft(ITrack sel, int index) {
        IChannelBank tb = this.model.getCurrentTrackBank();
        if (!tb.canScrollTracksUp()) {
            return;
        }
        tb.scrollTracksPageUp();
        int newSel = index == -1 || sel == null ? 7 : sel.getIndex();
        this.surface.scheduleTask(() -> this.selectTrack(newSel), 75L);
    }

    protected void scrollTracksRight() {
        int index;
        ITrack sel = this.model.getSelectedTrack();
        int n = index = sel == null ? 0 : sel.getIndex() + 1;
        if (index == 8 || this.surface.isShiftPressed()) {
            this.scrollTrackBankRight(sel, index);
            return;
        }
        this.selectTrack(index);
    }

    protected void scrollTrackBankRight(ITrack sel, int index) {
        IChannelBank tb = this.model.getCurrentTrackBank();
        if (!tb.canScrollTracksDown()) {
            return;
        }
        tb.scrollTracksPageDown();
        int newSel = index == 8 || sel == null ? 0 : sel.getIndex();
        this.surface.scheduleTask(() -> this.selectTrack(newSel), 75L);
    }

    public static enum Direction {
        LEFT,
        RIGHT,
        UP,
        DOWN;

    }
}

