/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class BrowserCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private static final int NUMBER_OF_RETRIES = 20;
    protected Integer browserMode;
    protected int startRetries;

    public BrowserCommand(Integer browserMode, IModel model, S surface) {
        super(model, surface);
        this.browserMode = browserMode;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (this.surface.isSelectPressed()) {
            this.startBrowser(true, false);
        } else {
            this.startBrowser(false, false);
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.startBrowser(true, true);
        }
    }

    public void startBrowser(boolean insertDevice, boolean beforeCurrent) {
        IBrowser browser = this.model.getBrowser();
        if (browser.isActive()) {
            this.discardBrowser(this.getCommit());
            return;
        }
        if (!insertDevice && this.model.getCursorDevice().hasSelectedDevice()) {
            browser.browseForPresets();
        } else if (beforeCurrent) {
            browser.browseToInsertBeforeDevice();
        } else {
            browser.browseToInsertAfterDevice();
        }
        this.startRetries = 0;
        this.activateMode();
    }

    protected void activateMode() {
        if (this.model.getBrowser().isActive()) {
            this.surface.getModeManager().setActiveMode(this.browserMode);
        } else if (this.startRetries < 20) {
            ++this.startRetries;
            this.surface.scheduleTask(this::activateMode, 200L);
        }
    }

    protected void discardBrowser(boolean commit) {
        this.model.getBrowser().stopBrowsing(commit);
        this.surface.getModeManager().restoreMode();
    }

    protected boolean getCommit() {
        return !this.surface.isShiftPressed();
    }
}

