/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.core;

import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.View;

public abstract class AbstractTriggerCommand<S extends IControlSurface<C>, C extends Configuration>
implements TriggerCommand {
    protected final IModel model;
    protected final S surface;

    public AbstractTriggerCommand(IModel model, S surface) {
        this.model = model;
        this.surface = surface;
    }

    @Override
    public void execute(ButtonEvent event) {
        if (this.surface.isShiftPressed()) {
            this.executeShifted(event);
        } else {
            this.executeNormal(event);
        }
    }

    @Override
    public void executeNormal(ButtonEvent event) {
    }

    @Override
    public void executeShifted(ButtonEvent event) {
    }

    protected void selectTrack(int index) {
        View activeView = this.surface.getViewManager().getActiveView();
        if (activeView != null) {
            activeView.selectTrack(index);
        }
    }
}

