/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.continuous;

import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.command.core.AbstractContinuousCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;

public class FootswitchCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractContinuousCommand<S, C>
implements TriggerCommand {
    public FootswitchCommand(IModel model, S surface) {
        super(model, surface);
    }

    @Override
    public void execute(int value) {
        this.execute(value == 127 ? ButtonEvent.DOWN : ButtonEvent.UP);
    }

    @Override
    public void execute(ButtonEvent event) {
        switch (this.getSetting()) {
            case 0: {
                this.surface.getViewManager().getActiveView().executeTriggerCommand(Commands.COMMAND_PLAY, event);
                break;
            }
            case 1: {
                this.surface.getViewManager().getActiveView().executeTriggerCommand(Commands.COMMAND_RECORD, event);
                break;
            }
            case 2: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getCurrentTrackBank().stop();
                break;
            }
            case 3: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getTransport().toggleLauncherOverdub();
                break;
            }
            case 4: {
                this.surface.getViewManager().getActiveView().executeTriggerCommand(Commands.COMMAND_UNDO, event);
                break;
            }
            case 5: {
                this.surface.getViewManager().getActiveView().executeTriggerCommand(Commands.COMMAND_TAP_TEMPO, event);
                break;
            }
            case 6: {
                this.surface.getViewManager().getActiveView().executeTriggerCommand(Commands.COMMAND_NEW, event);
                break;
            }
            case 7: {
                ISlot slot;
                ITrack track = this.model.getSelectedTrack();
                if (track == null) {
                    this.surface.getDisplay().notify("Please select an Instrument track first.", true, true);
                    return;
                }
                ISlot selectedSlot = track.getSelectedSlot();
                ISlot iSlot = slot = selectedSlot == null ? track.getSlot(0) : selectedSlot;
                if (event == ButtonEvent.DOWN) {
                    if (slot.hasContent()) {
                        this.model.getTransport().setLauncherOverdub(true);
                    } else {
                        this.surface.getViewManager().getActiveView().executeTriggerCommand(Commands.COMMAND_NEW, event);
                        slot.select();
                        this.model.getTransport().setLauncherOverdub(true);
                    }
                } else {
                    this.model.getTransport().setLauncherOverdub(false);
                }
                slot.launch();
                break;
            }
            case 8: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getApplication().setPanelLayout("ARRANGE");
                break;
            }
            case 9: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getApplication().setPanelLayout("MIX");
                break;
            }
            case 10: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getApplication().setPanelLayout("EDIT");
                break;
            }
            case 11: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getApplication().addInstrumentTrack();
                break;
            }
            case 12: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getApplication().addAudioTrack();
                break;
            }
            case 13: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getApplication().addEffectTrack();
                break;
            }
            case 14: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getCursorClip().quantize((double)this.surface.getConfiguration().getQuantizeAmount() / 100.0);
            }
        }
    }

    @Override
    public void executeNormal(ButtonEvent event) {
    }

    @Override
    public void executeShifted(ButtonEvent event) {
    }

    protected int getSetting() {
        return this.surface.getConfiguration().getFootswitch2();
    }
}

