/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.continuous;

import de.mossgrabers.framework.command.core.AbstractContinuousCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;

public class FaderAbsoluteCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractContinuousCommand<S, C> {
    private int index;

    public FaderAbsoluteCommand(int index, IModel model, S surface) {
        super(model, surface);
        this.index = index;
    }

    @Override
    public void execute(int value) {
        IChannelBank currentTrackBank = this.model.getCurrentTrackBank();
        ITrack track = currentTrackBank.getTrack(this.index);
        if (!track.doesExist()) {
            return;
        }
        if (this.surface.isShiftPressed()) {
            int volume = track.getVolume();
            this.surface.getDisplay().notify(volume < value ? "Move down" : (volume > value ? "Move up" : "Perfect!"));
        } else {
            track.setVolume(value);
        }
    }
}

