/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.aftertouch;

import de.mossgrabers.framework.command.core.AbstractAftertouchCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.view.AbstractPlayView;
import java.util.List;

public class AftertouchAbstractPlayViewCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractAftertouchCommand<S, C> {
    private AbstractPlayView<S, C> view;

    public AftertouchAbstractPlayViewCommand(AbstractPlayView<S, C> view, IModel model, S surface) {
        super(model, surface);
        this.view = view;
    }

    @Override
    public void onPolyAftertouch(int note, int value) {
        Object config = this.surface.getConfiguration();
        switch (config.getConvertAftertouch()) {
            case -3: {
                break;
            }
            case -2: {
                int n = this.view.getMidiNoteFromGrid(note);
                if (n == -1) break;
                this.surface.sendMidiEvent(160, n, value);
                break;
            }
            case -1: {
                this.surface.sendMidiEvent(208, value, 0);
                break;
            }
            default: {
                this.surface.sendMidiEvent(176, config.getConvertAftertouch(), value);
            }
        }
    }

    @Override
    public void onChannelAftertouch(int value) {
        Object config = this.surface.getConfiguration();
        if (config.getConvertAftertouch() == -2) {
            List<Integer> keys = this.view.getPressedKeys();
            for (int i = 0; i < keys.size(); ++i) {
                this.onPolyAftertouch(keys.get(i), value);
            }
        } else {
            this.onPolyAftertouch(0, value);
        }
    }
}

