/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.sl.view;

import de.mossgrabers.controller.sl.SLConfiguration;
import de.mossgrabers.controller.sl.controller.SLControlSurface;
import de.mossgrabers.controller.sl.mode.Modes;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.StopCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;

public class TransportControl {
    private SLControlSurface surface;
    private IModel model;
    private boolean isRewinding;
    private boolean isForwarding;
    private final PlayCommand<SLControlSurface, SLConfiguration> playCommand;
    private final StopCommand<SLControlSurface, SLConfiguration> stopCommand;

    public TransportControl(SLControlSurface surface, IModel model) {
        this.surface = surface;
        this.model = model;
        this.playCommand = new PlayCommand(model, surface);
        this.stopCommand = new StopCommand(model, surface);
    }

    public void execute(int index, ButtonEvent event) {
        switch (index) {
            case 0: {
                this.onRewind(event);
                break;
            }
            case 1: {
                this.onForward(event);
                break;
            }
            case 2: {
                this.onStop(event);
                break;
            }
            case 3: {
                this.onPlay(event);
                break;
            }
            case 4: {
                this.onLoop(event);
                break;
            }
            case 5: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getTransport().record();
                break;
            }
            case 6: {
                this.onRecord(event);
                break;
            }
        }
    }

    private void onRewind(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.isRewinding = true;
        } else if (event == ButtonEvent.UP) {
            this.isRewinding = false;
        }
        this.doChangePosition();
    }

    private void onForward(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.isForwarding = true;
        } else if (event == ButtonEvent.UP) {
            this.isForwarding = false;
        }
        this.doChangePosition();
    }

    private void doChangePosition() {
        if (!this.isRewinding && !this.isForwarding) {
            this.turnOffTransport();
            return;
        }
        this.model.getTransport().changePosition(this.isForwarding, false);
        this.surface.scheduleTask(this::doChangePosition, 100L);
    }

    private void onPlay(ButtonEvent event) {
        this.playCommand.executeNormal(event);
        this.turnOffTransport();
    }

    private void onStop(ButtonEvent event) {
        this.stopCommand.executeNormal(event);
        this.turnOffTransport();
    }

    private void onRecord(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.model.getTransport().toggleLauncherOverdub();
        this.turnOffTransport();
    }

    private void onLoop(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.model.getTransport().toggleLoop();
        this.turnOffTransport();
    }

    private void turnOffTransport() {
        this.surface.turnOffTransport();
        ModeManager modeManager = this.surface.getModeManager();
        if (modeManager.isActiveMode(Modes.MODE_VIEW_SELECT)) {
            modeManager.restoreMode();
        }
    }
}

