/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.sl.view;

import de.mossgrabers.controller.sl.SLConfiguration;
import de.mossgrabers.controller.sl.command.trigger.ButtonRowSelectCommand;
import de.mossgrabers.controller.sl.command.trigger.P2ButtonCommand;
import de.mossgrabers.controller.sl.controller.SLControlSurface;
import de.mossgrabers.controller.sl.mode.Modes;
import de.mossgrabers.controller.sl.mode.device.DeviceParamsMode;
import de.mossgrabers.controller.sl.view.SLView;
import de.mossgrabers.controller.sl.view.TransportControl;
import de.mossgrabers.controller.sl.view.Views;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractSequencerView;
import java.util.Arrays;

public class PlayView
extends AbstractSequencerView<SLControlSurface, SLConfiguration>
implements SLView {
    private static final int NUM_DISPLAY_COLS = 16;
    private static final int NOTE_VELOCITY = 127;
    private int selectedPad;
    private boolean isPlayMode;
    protected int[] pressedKeys;
    private TransportControl transportControl;

    public PlayView(SLControlSurface surface, IModel model) {
        super("Play", surface, model, 128, 16);
        this.transportControl = new TransportControl(surface, model);
        this.offsetY = 36;
        this.selectedPad = 0;
        this.pressedKeys = new int[128];
        Arrays.fill(this.pressedKeys, 0);
        this.noteMap = Scales.getEmptyMatrix();
        this.isPlayMode = true;
        ITrackBank tb = model.getTrackBank();
        tb.addNoteObserver((note, velocity) -> {
            this.pressedKeys[note] = velocity;
        });
        tb.addTrackSelectionObserver((index, isSelected) -> this.clearPressedKeys());
    }

    @Override
    public void onButtonRow1(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((SLControlSurface)this.surface).getModeManager();
        Integer activeModeId = modeManager.getActiveModeId();
        if (activeModeId == Modes.MODE_VIEW_SELECT) {
            if (index == 0) {
                ((SLControlSurface)this.surface).getViewManager().setActiveView(Views.VIEW_CONTROL);
                if (modeManager.getPreviousModeId() == Modes.MODE_VOLUME) {
                    modeManager.restoreMode();
                } else {
                    modeManager.setActiveMode(Modes.MODE_TRACK);
                }
            } else {
                modeManager.restoreMode();
            }
            ((SLControlSurface)this.surface).turnOffTransport();
            return;
        }
        if (activeModeId != Modes.MODE_SESSION) {
            modeManager.setActiveMode(Modes.MODE_SESSION);
        }
        this.model.getSceneBank().launchScene(index);
    }

    @Override
    public void onButtonRow2(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((SLControlSurface)this.surface).getModeManager();
        Integer cm = modeManager.getActiveModeId();
        if (cm != Modes.MODE_PLAY_OPTIONS) {
            modeManager.setActiveMode(Modes.MODE_PLAY_OPTIONS);
        }
        switch (index) {
            case 0: {
                this.clearPressedKeys();
                this.scales.decDrumOctave();
                this.model.getPrimaryDevice().scrollDrumPadsPageUp();
                this.offsetY = 36 + this.scales.getDrumOctave() * 16;
                this.updateNoteMapping();
                ((SLControlSurface)this.surface).getDisplay().notify(this.scales.getDrumRangeText());
                break;
            }
            case 1: {
                this.clearPressedKeys();
                this.scales.incDrumOctave();
                this.model.getPrimaryDevice().scrollDrumPadsPageDown();
                this.offsetY = 36 + this.scales.getDrumOctave() * 16;
                this.updateNoteMapping();
                ((SLControlSurface)this.surface).getDisplay().notify(this.scales.getDrumRangeText());
                break;
            }
            case 2: {
                this.changeResolution(0);
                ((SLControlSurface)this.surface).getDisplay().notify(RESOLUTION_TEXTS[this.selectedIndex]);
                break;
            }
            case 3: {
                this.changeResolution(127);
                ((SLControlSurface)this.surface).getDisplay().notify(RESOLUTION_TEXTS[this.selectedIndex]);
                break;
            }
            case 4: {
                this.changeScrollPosition(0);
                break;
            }
            case 5: {
                this.changeScrollPosition(127);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.isPlayMode = !this.isPlayMode;
                ((SLControlSurface)this.surface).getDisplay().notify(this.isPlayMode ? "Play/Select" : "Sequence");
                this.updateNoteMapping();
                break;
            }
        }
    }

    @Override
    public void onButtonRow3(int index, ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.onSeqGridNote(44 + index, 127);
        } else if (event == ButtonEvent.UP) {
            this.onSeqGridNote(44 + index, 0);
        }
    }

    @Override
    public void onButtonRow4(int index, ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.onSeqGridNote(36 + index, 127);
        } else if (event == ButtonEvent.UP) {
            this.onSeqGridNote(36 + index, 0);
        }
    }

    @Override
    public void onButtonRow5(int index, ButtonEvent event) {
        this.transportControl.execute(index, event);
    }

    @Override
    public void onButtonRow1Select() {
        ((SLControlSurface)this.surface).getModeManager().setActiveMode(Modes.MODE_SESSION);
    }

    @Override
    public void onButtonRow2Select() {
        ((SLControlSurface)this.surface).getModeManager().setActiveMode(Modes.MODE_PLAY_OPTIONS);
    }

    @Override
    public void onButtonP1(boolean isUp, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        Integer activeModeId = ((SLControlSurface)this.surface).getModeManager().getActiveModeId();
        if (activeModeId == Modes.MODE_SESSION) {
            if (isUp) {
                this.model.getSceneBank().scrollScenesPageDown();
            } else {
                this.model.getSceneBank().scrollScenesPageUp();
            }
            return;
        }
        if (activeModeId == Modes.MODE_VOLUME) {
            new P2ButtonCommand(isUp, this.model, (SLControlSurface)this.surface).execute(event);
            return;
        }
        if (activeModeId == Modes.MODE_TRACK || activeModeId == Modes.MODE_MASTER) {
            new ButtonRowSelectCommand(3, this.model, this.surface).execute(event);
            return;
        }
        if (activeModeId == Modes.MODE_PLAY_OPTIONS) {
            return;
        }
        ModeManager modeManager = ((SLControlSurface)this.surface).getModeManager();
        if (isUp) {
            ((DeviceParamsMode)modeManager.getMode(Modes.MODE_PARAMS)).nextPage();
        } else {
            ((DeviceParamsMode)modeManager.getMode(Modes.MODE_PARAMS)).previousPage();
        }
    }

    @Override
    public void updateButtons() {
        int i;
        for (i = 0; i < 8; ++i) {
            ((SLControlSurface)this.surface).updateButton(24 + i, 0);
        }
        for (i = 0; i < 8; ++i) {
            ((SLControlSurface)this.surface).updateButton(32 + i, 0);
        }
        ((DeviceParamsMode)((SLControlSurface)this.surface).getModeManager().getMode(Modes.MODE_PARAMS)).setLEDs();
        if (((SLControlSurface)this.surface).isTransportActive()) {
            for (i = 0; i < 8; ++i) {
                ((SLControlSurface)this.surface).updateButton(40 + i, 0);
            }
            ITransport transport = this.model.getTransport();
            ((SLControlSurface)this.surface).updateButton(50, !transport.isPlaying() ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(51, transport.isPlaying() ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(52, transport.isLoop() ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(53, transport.isRecording() ? 1 : 0);
        } else {
            this.drawDrumGrid();
        }
        Integer mode = ((SLControlSurface)this.surface).getModeManager().getActiveModeId();
        boolean isSession = mode == Modes.MODE_SESSION;
        boolean isDevice = mode == Modes.MODE_PARAMS;
        boolean isPlayOptions = mode == Modes.MODE_PLAY_OPTIONS;
        boolean isTrack = mode == Modes.MODE_TRACK;
        boolean isMaster = mode == Modes.MODE_MASTER;
        boolean isVolume = mode == Modes.MODE_VOLUME;
        ((SLControlSurface)this.surface).updateButton(80, isSession ? 1 : 0);
        ((SLControlSurface)this.surface).updateButton(81, isDevice ? 1 : 0);
        ((SLControlSurface)this.surface).updateButton(82, isPlayOptions ? 1 : 0);
        ((SLControlSurface)this.surface).updateButton(83, isTrack || isMaster ? 1 : 0);
        ((SLControlSurface)this.surface).updateButton(85, isVolume ? 1 : 0);
        ((SLControlSurface)this.surface).updateButton(86, 0);
    }

    public void drawDrumGrid() {
        if (!this.model.canSelectedTrackHoldNotes()) {
            int i;
            for (i = 0; i < 8; ++i) {
                ((SLControlSurface)this.surface).updateButton(40 + i, 0);
            }
            for (i = 0; i < 8; ++i) {
                ((SLControlSurface)this.surface).updateButton(48 + i, 0);
            }
            return;
        }
        if (this.isPlayMode) {
            ICursorDevice primary = this.model.getPrimaryDevice();
            boolean hasDrumPads = primary.hasDrumPads();
            boolean isSoloed = false;
            if (hasDrumPads) {
                for (int i = 0; i < 16; ++i) {
                    if (!primary.getDrumPad(i).isSolo()) continue;
                    isSoloed = true;
                    break;
                }
            }
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 8; ++x) {
                    int index = 8 * y + x;
                    int color = this.getPadColor(index, primary, isSoloed);
                    if (y == 0) {
                        ((SLControlSurface)this.surface).updateButton(48 + x, color);
                        continue;
                    }
                    ((SLControlSurface)this.surface).updateButton(40 + x, color);
                }
            }
        } else {
            ICursorClip clip = this.getClip();
            int step = clip.getCurrentStep();
            int hiStep = this.isInXRange(step) ? step % 16 : -1;
            for (int col = 0; col < 16; ++col) {
                int color;
                int isSet = clip.getStep(col, this.offsetY + this.selectedPad);
                boolean hilite = col == hiStep;
                int x = col % 8;
                double y = (double)col / 8.0;
                int n = isSet > 0 ? 1 : (color = hilite ? 1 : 0);
                if (y == 0.0) {
                    ((SLControlSurface)this.surface).updateButton(40 + x, color);
                    continue;
                }
                ((SLControlSurface)this.surface).updateButton(48 + x, color);
            }
        }
    }

    public void clearPressedKeys() {
        for (int i = 0; i < 128; ++i) {
            this.pressedKeys[i] = 0;
        }
    }

    public void onSeqGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int index = note - 36;
        if (this.isPlayMode) {
            this.selectedPad = index;
            this.pressedKeys[this.offsetY + this.selectedPad] = velocity;
            ((SLControlSurface)this.surface).sendMidiEvent(144, this.noteMap[note], velocity);
        } else if (velocity != 0) {
            this.getClip().toggleStep(index < 8 ? index + 8 : index - 8, this.offsetY + this.selectedPad, this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : velocity);
        }
    }

    @Override
    public void updateNoteMapping() {
        this.noteMap = this.model.canSelectedTrackHoldNotes() && this.isPlayMode ? this.scales.getDrumMatrix() : Scales.getEmptyMatrix();
        ((SLControlSurface)this.surface).setKeyTranslationTable(this.noteMap);
    }

    private int getPadColor(int index, ICursorDevice primary, boolean isSoloed) {
        if (this.pressedKeys[this.offsetY + index] > 0) {
            return 1;
        }
        if (this.selectedPad == index) {
            return 1;
        }
        IDrumPad drumPad = primary.getDrumPad(index);
        if (!drumPad.doesExist() || !drumPad.isActivated()) {
            return 0;
        }
        if (drumPad.isMute() || isSoloed && !drumPad.isSolo()) {
            return 0;
        }
        return 0;
    }

    private void changeScrollPosition(int value) {
        boolean isInc;
        boolean bl = isInc = value >= 65;
        if (isInc) {
            this.getClip().scrollStepsPageForward();
        } else {
            this.getClip().scrollStepsPageBackwards();
        }
    }

    private void changeResolution(int value) {
        boolean isInc = value >= 65;
        this.selectedIndex = Math.max(0, Math.min(RESOLUTIONS.length - 1, isInc ? this.selectedIndex + 1 : this.selectedIndex - 1));
        this.getClip().setStepLength(RESOLUTIONS[this.selectedIndex]);
    }

    @Override
    public void drawGrid() {
    }

    @Override
    public void onGridNote(int note, int velocity) {
    }

    @Override
    public void updateSceneButtons() {
    }
}

