/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.sl.view;

import de.mossgrabers.controller.sl.SLConfiguration;
import de.mossgrabers.controller.sl.command.trigger.ButtonRowSelectCommand;
import de.mossgrabers.controller.sl.command.trigger.P2ButtonCommand;
import de.mossgrabers.controller.sl.controller.SLControlSurface;
import de.mossgrabers.controller.sl.mode.Modes;
import de.mossgrabers.controller.sl.mode.device.DeviceParamsMode;
import de.mossgrabers.controller.sl.mode.device.DevicePresetsMode;
import de.mossgrabers.controller.sl.view.SLView;
import de.mossgrabers.controller.sl.view.TransportControl;
import de.mossgrabers.controller.sl.view.Views;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractView;

public class ControlView
extends AbstractView<SLControlSurface, SLConfiguration>
implements SLView {
    private boolean isTempoDec;
    private boolean isTempoInc;
    private TransportControl transportControl;

    public ControlView(SLControlSurface surface, IModel model) {
        super("Control", surface, model);
        this.transportControl = new TransportControl(surface, model);
    }

    @Override
    public void onButtonRow1(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((SLControlSurface)this.surface).getModeManager();
        Integer activeModeId = modeManager.getActiveModeId();
        if (activeModeId == Modes.MODE_VIEW_SELECT) {
            if (index == 1) {
                ((SLControlSurface)this.surface).getViewManager().setActiveView(Views.VIEW_PLAY);
                if (modeManager.getPreviousModeId() == Modes.MODE_VOLUME) {
                    modeManager.restoreMode();
                } else {
                    modeManager.setActiveMode(Modes.MODE_SESSION);
                }
            } else {
                modeManager.restoreMode();
            }
            ((SLControlSurface)this.surface).turnOffTransport();
            return;
        }
        if (activeModeId != Modes.MODE_FUNCTIONS && activeModeId != Modes.MODE_FIXED) {
            modeManager.setActiveMode(Modes.MODE_FUNCTIONS);
            activeModeId = Modes.MODE_FUNCTIONS;
        }
        if (activeModeId == Modes.MODE_FIXED) {
            ((SLConfiguration)((SLControlSurface)this.surface).getConfiguration()).setNewClipLength(index);
            return;
        }
        switch (index) {
            case 0: {
                this.model.getApplication().undo();
                break;
            }
            case 1: {
                this.model.getApplication().redo();
                break;
            }
            case 2: {
                this.model.getApplication().deleteSelection();
                break;
            }
            case 3: {
                this.model.getApplication().duplicate();
                break;
            }
            case 4: {
                ITrack t = this.model.getSelectedTrack();
                if (t == null) {
                    return;
                }
                ISlot[] slotIndexes = t.getSelectedSlots();
                int slotIndex = slotIndexes.length == 0 ? 0 : slotIndexes[0].getIndex();
                for (int i = 0; i < 8; ++i) {
                    int sIndex = (slotIndex + i) % 8;
                    ISlot s = t.getSlot(sIndex);
                    if (s.hasContent()) continue;
                    this.model.createClip(s, ((SLConfiguration)((SLControlSurface)this.surface).getConfiguration()).getNewClipLength());
                    if (slotIndex != sIndex) {
                        s.select();
                    }
                    s.launch();
                    this.model.getTransport().setLauncherOverdub(true);
                    return;
                }
                ((SLControlSurface)this.surface).getDisplay().notify("In the current selected grid view there is no empty slot. Please scroll down.");
                break;
            }
            case 5: {
                this.model.getCursorDevice().toggleWindowOpen();
                break;
            }
            case 6: {
                this.model.getTransport().toggleMetronome();
                break;
            }
            case 7: {
                this.model.getTransport().tapTempo();
            }
        }
    }

    @Override
    public void onButtonRow2(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((SLControlSurface)this.surface).getModeManager();
        Integer cm = modeManager.getActiveModeId();
        if (cm != Modes.MODE_TRACK_TOGGLES && cm != Modes.MODE_FRAME && cm != Modes.MODE_BROWSER) {
            modeManager.setActiveMode(Modes.MODE_TRACK_TOGGLES);
            cm = Modes.MODE_TRACK_TOGGLES;
        }
        if (cm == Modes.MODE_FRAME) {
            modeManager.getMode(Modes.MODE_FRAME).onRowButton(0, index, event);
            return;
        }
        if (cm == Modes.MODE_BROWSER) {
            modeManager.getMode(Modes.MODE_BROWSER).onRowButton(0, index, event);
            return;
        }
        switch (index) {
            case 0: {
                ITrack track = this.model.getSelectedTrack();
                if (track == null) break;
                track.toggleMute();
                break;
            }
            case 1: {
                ITrack track = this.model.getSelectedTrack();
                if (track == null) break;
                track.toggleSolo();
                break;
            }
            case 2: {
                ITrack track = this.model.getSelectedTrack();
                if (track == null) break;
                track.toggleRecArm();
                break;
            }
            case 3: {
                this.model.getTransport().toggleWriteArrangerAutomation();
                break;
            }
            case 4: {
                this.model.getBrowser().browseForPresets();
                modeManager.setActiveMode(Modes.MODE_BROWSER);
                break;
            }
            case 5: {
                this.model.getCursorDevice().toggleEnabledState();
                break;
            }
            case 6: {
                this.model.getCursorDevice().selectPrevious();
                break;
            }
            case 7: {
                this.model.getCursorDevice().selectNext();
            }
        }
    }

    @Override
    public void onButtonRow3(int index, ButtonEvent event) {
        if (!this.model.getMasterTrack().isSelected()) {
            this.selectTrack(index);
        }
    }

    @Override
    public void onButtonRow4(int index, ButtonEvent event) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.transportControl.execute(index, event);
                break;
            }
            case 6: {
                if (event == ButtonEvent.DOWN) {
                    this.isTempoDec = true;
                } else if (event == ButtonEvent.UP) {
                    this.isTempoDec = false;
                }
                this.doChangeTempo();
                break;
            }
            case 7: {
                if (event == ButtonEvent.DOWN) {
                    this.isTempoInc = true;
                } else if (event == ButtonEvent.UP) {
                    this.isTempoInc = false;
                }
                this.doChangeTempo();
            }
        }
    }

    @Override
    public void onButtonRow5(int index, ButtonEvent event) {
        this.transportControl.execute(index, event);
    }

    private void doChangeTempo() {
        if (!this.isTempoInc && !this.isTempoDec) {
            return;
        }
        this.model.getTransport().changeTempo(this.isTempoInc);
        ((SLControlSurface)this.surface).scheduleTask(this::doChangeTempo, 200L);
    }

    @Override
    public void onButtonRow1Select() {
        ModeManager modeManager = ((SLControlSurface)this.surface).getModeManager();
        boolean selectFixed = modeManager.getActiveModeId() == Modes.MODE_FUNCTIONS;
        modeManager.setActiveMode(selectFixed ? Modes.MODE_FIXED : Modes.MODE_FUNCTIONS);
        ((SLControlSurface)this.surface).getDisplay().notify(selectFixed ? "Fixed Length" : "Functions");
    }

    @Override
    public void onButtonRow2Select() {
        ModeManager modeManager = ((SLControlSurface)this.surface).getModeManager();
        boolean selectFrame = modeManager.getActiveModeId() == Modes.MODE_TRACK_TOGGLES;
        modeManager.setActiveMode(selectFrame ? Modes.MODE_FRAME : Modes.MODE_TRACK_TOGGLES);
        ((SLControlSurface)this.surface).getDisplay().notify(selectFrame ? "Layouts & Panels" : "Track & Device");
    }

    @Override
    public void onButtonP1(boolean isUp, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((SLControlSurface)this.surface).getModeManager();
        Integer activeModeId = modeManager.getActiveModeId();
        if (activeModeId == Modes.MODE_FUNCTIONS || activeModeId == Modes.MODE_FIXED) {
            this.onButtonRow1Select();
        } else if (activeModeId == Modes.MODE_VOLUME) {
            new P2ButtonCommand(isUp, this.model, (SLControlSurface)this.surface).execute(event);
        } else if (activeModeId == Modes.MODE_TRACK || activeModeId == Modes.MODE_MASTER) {
            new ButtonRowSelectCommand(3, this.model, this.surface).execute(event);
        } else if (activeModeId == Modes.MODE_TRACK_TOGGLES || activeModeId == Modes.MODE_FRAME) {
            this.onButtonRow2Select();
        } else if (isUp) {
            ((DeviceParamsMode)modeManager.getMode(Modes.MODE_PARAMS)).nextPage();
        } else {
            ((DeviceParamsMode)modeManager.getMode(Modes.MODE_PARAMS)).previousPage();
        }
    }

    @Override
    public void updateButtons() {
        int i;
        boolean isFunctions;
        IChannelBank tb = this.model.getCurrentTrackBank();
        ICursorDevice cd = this.model.getCursorDevice();
        ITransport transport = this.model.getTransport();
        int clipLength = ((SLConfiguration)((SLControlSurface)this.surface).getConfiguration()).getNewClipLength();
        Integer mode = ((SLControlSurface)this.surface).getModeManager().getActiveModeId();
        boolean isTrack = mode == Modes.MODE_TRACK;
        boolean isTrackToggles = mode == Modes.MODE_TRACK_TOGGLES;
        boolean isVolume = mode == Modes.MODE_VOLUME;
        boolean isMaster = mode == Modes.MODE_MASTER;
        boolean isFixed = mode == Modes.MODE_FIXED;
        boolean isFrame = mode == Modes.MODE_FRAME;
        boolean isPreset = mode == Modes.MODE_BROWSER;
        boolean isDevice = mode == Modes.MODE_PARAMS;
        boolean bl = isFunctions = mode == Modes.MODE_FUNCTIONS;
        if (mode == Modes.MODE_VIEW_SELECT) {
            for (i = 0; i < 8; ++i) {
                ((SLControlSurface)this.surface).updateButton(24 + i, 0);
            }
        } else {
            ((SLControlSurface)this.surface).updateButton(24, !isFunctions && clipLength == 0 ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(25, !isFunctions && clipLength == 1 ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(26, !isFunctions && clipLength == 2 ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(27, !isFunctions && clipLength == 3 ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(28, !isFunctions && clipLength == 4 ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(29, isFunctions && this.model.getCursorDevice().isWindowOpen() || !isFunctions && clipLength == 5 ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(30, isFunctions && transport.isMetronomeOn() || !isFunctions && clipLength == 6 ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(31, !isFunctions && clipLength == 7 ? 1 : 0);
        }
        if (mode == Modes.MODE_BROWSER) {
            int selMode = ((DevicePresetsMode)((SLControlSurface)this.surface).getModeManager().getMode(Modes.MODE_BROWSER)).getSelectionMode();
            ((SLControlSurface)this.surface).updateButton(32, 1);
            ((SLControlSurface)this.surface).updateButton(33, 1);
            ((SLControlSurface)this.surface).updateButton(34, selMode == 0 ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(35, selMode == 0 ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(36, selMode == 0 ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(37, selMode == 0 ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(38, selMode == 0 ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(39, 1);
        } else {
            boolean isNoOverlayMode = mode != Modes.MODE_FRAME && mode != Modes.MODE_BROWSER;
            ITrack track = tb.getSelectedTrack();
            ((SLControlSurface)this.surface).updateButton(32, isNoOverlayMode && track != null && track.isMute() ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(33, isNoOverlayMode && track != null && track.isSolo() ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(34, isNoOverlayMode && track != null && track.isRecArm() ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(35, transport.isWritingArrangerAutomation() ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(36, 0);
            ((SLControlSurface)this.surface).updateButton(37, this.model.getCursorDevice().isEnabled() ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(38, isNoOverlayMode && cd.canSelectPreviousFX() ? 1 : 0);
            ((SLControlSurface)this.surface).updateButton(39, isNoOverlayMode && cd.canSelectNextFX() ? 1 : 0);
        }
        for (i = 0; i < 8; ++i) {
            ((SLControlSurface)this.surface).updateButton(40 + i, tb.getTrack(i).isSelected() ? 1 : 0);
        }
        ((DeviceParamsMode)((SLControlSurface)this.surface).getModeManager().getMode(Modes.MODE_PARAMS)).setLEDs();
        ((SLControlSurface)this.surface).updateButton(50, !transport.isPlaying() ? 1 : 0);
        ((SLControlSurface)this.surface).updateButton(51, transport.isPlaying() ? 1 : 0);
        ((SLControlSurface)this.surface).updateButton(52, transport.isLoop() ? 1 : 0);
        ((SLControlSurface)this.surface).updateButton(53, transport.isRecording() ? 1 : 0);
        ((SLControlSurface)this.surface).updateButton(80, isFunctions || isFixed ? 1 : 0);
        ((SLControlSurface)this.surface).updateButton(81, isDevice ? 1 : 0);
        ((SLControlSurface)this.surface).updateButton(82, isTrackToggles || isFrame || isPreset ? 1 : 0);
        ((SLControlSurface)this.surface).updateButton(83, isTrack || isMaster ? 1 : 0);
        ((SLControlSurface)this.surface).updateButton(85, isVolume ? 1 : 0);
        ((SLControlSurface)this.surface).updateButton(86, 0);
    }

    @Override
    public void drawGrid() {
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (((SLConfiguration)((SLControlSurface)this.surface).getConfiguration()).isDrumpadsAsModeSelection()) {
            if (velocity > 0) {
                int index = note - 36;
                new ButtonRowSelectCommand(index > 3 ? 5 : index, this.model, this.surface).execute(ButtonEvent.DOWN);
            }
            return;
        }
        ((SLControlSurface)this.surface).sendMidiEvent(144, note, velocity);
    }
}

