/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.sl.mode.device;

import de.mossgrabers.controller.sl.SLConfiguration;
import de.mossgrabers.controller.sl.controller.SLControlSurface;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IParameter;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.mode.AbstractMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class DeviceParamsMode
extends AbstractMode<SLControlSurface, SLConfiguration> {
    public DeviceParamsMode(SLControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
    }

    @Override
    public void updateDisplay() {
        Display d = ((SLControlSurface)this.surface).getDisplay().clearRow(0).clearRow(2);
        ICursorDevice cd = this.model.getCursorDevice();
        if (cd.hasSelectedDevice()) {
            for (int i = 0; i < 8; ++i) {
                IParameter param = cd.getFXParam(i);
                d.setCell(0, i, param.doesExist() ? StringUtils.shortenAndFixASCII(param.getName(), 8) : "").setCell(2, i, param.getDisplayedValue(8));
            }
        } else {
            d.setRow(0, "                       Please select a device...                       ");
        }
        d.done(0).done(2);
    }

    @Override
    public void onValueKnob(int index, int value) {
        this.model.getCursorDevice().changeParameter(index, value);
    }

    public void setLEDs() {
        boolean hasDevice = this.model.hasSelectedDevice();
        IMidiOutput output = ((SLControlSurface)this.surface).getOutput();
        for (int i = 0; i < 8; ++i) {
            int value = hasDevice ? this.model.getCursorDevice().getFXParam(i).getValue() : 0;
            output.sendCC(112 + i, Math.min(value * 11 / 127, 11));
        }
    }

    public void previousPage() {
        this.model.getCursorDevice().previousParameterPage();
    }

    public void nextPage() {
        this.model.getCursorDevice().nextParameterPage();
    }

    @Override
    public void onRowButton(int row, int index, ButtonEvent event) {
    }
}

