/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.sl.mode;

import de.mossgrabers.controller.sl.SLConfiguration;
import de.mossgrabers.controller.sl.controller.SLControlSurface;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.AbstractMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class VolumeMode
extends AbstractMode<SLControlSurface, SLConfiguration> {
    public VolumeMode(SLControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
    }

    @Override
    public void updateDisplay() {
        Display d = ((SLControlSurface)this.surface).getDisplay();
        IMasterTrack masterTrack = this.model.getMasterTrack();
        if (masterTrack.isSelected()) {
            d.clear();
            String n = StringUtils.shortenAndFixASCII(masterTrack.getName(), 7);
            d.setCell(1, 0, ">" + n).setCell(3, 0, masterTrack.getVolumeStr(8)).done(1).done(3);
            return;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack selTrack = tb.getSelectedTrack();
        int selIndex = selTrack == null ? -1 : selTrack.getIndex();
        for (int i = 0; i < 8; ++i) {
            boolean isSel = i == selIndex;
            ITrack t = tb.getTrack(i);
            String n = StringUtils.shortenAndFixASCII(t.getName(), isSel ? 7 : 8);
            d.setCell(1, i, isSel ? ">" + n : n).setCell(3, i, t.getVolumeStr(8));
        }
        d.done(1).done(3);
    }

    @Override
    public void onRowButton(int row, int index, ButtonEvent event) {
    }
}

