/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.sl.mode;

import de.mossgrabers.controller.sl.SLConfiguration;
import de.mossgrabers.controller.sl.controller.SLControlSurface;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.AbstractMode;
import de.mossgrabers.framework.utils.ButtonEvent;

public class TrackTogglesMode
extends AbstractMode<SLControlSurface, SLConfiguration> {
    private static final String OFF = "   Off";
    private static final String ON = "   On";

    public TrackTogglesMode(SLControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
    }

    @Override
    public void updateDisplay() {
        ITrack t = this.model.getSelectedTrack();
        Display d = ((SLControlSurface)this.surface).getDisplay();
        if (t == null) {
            d.setRow(0, "                        Please select a track...                       ").clearRow(2).done(2);
        } else {
            ICursorDevice device = this.model.getCursorDevice();
            d.setCell(0, 0, "  Mute");
            d.setCell(2, 0, t.isMute() ? ON : OFF);
            d.setCell(0, 1, "  Solo");
            d.setCell(2, 1, t.isSolo() ? ON : OFF);
            d.setCell(0, 2, "Rec Arm");
            d.setCell(2, 2, t.isRecArm() ? ON : OFF);
            d.setCell(0, 3, " Write");
            d.setCell(2, 3, this.model.getTransport().isWritingArrangerAutomation() ? ON : OFF);
            d.setCell(0, 4, " Browse");
            d.setCell(2, 4, "");
            d.setCell(0, 5, device.doesExist() ? device.getName(8) : "None");
            d.setCell(2, 5, device.isEnabled() ? "Enabled" : "Disabled");
            d.setCell(0, 6, "<<Device").setCell(2, 6, "");
            d.setCell(0, 7, "Device>>").setCell(2, 7, "").done(0).done(2);
        }
    }

    @Override
    public void onRowButton(int row, int index, ButtonEvent event) {
    }
}

