/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.sl.mode;

import de.mossgrabers.controller.sl.SLConfiguration;
import de.mossgrabers.controller.sl.controller.SLControlSurface;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.AbstractMode;
import de.mossgrabers.framework.utils.ButtonEvent;

public class TrackMode
extends AbstractMode<SLControlSurface, SLConfiguration> {
    public TrackMode(SLControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
    }

    @Override
    public void updateDisplay() {
        IChannelBank fxTrackBank;
        ITrack t = this.model.getSelectedTrack();
        Display d = ((SLControlSurface)this.surface).getDisplay();
        if (t == null) {
            d.setRow(0, "                        Please select a track...                       ").clearRow(2).done(2);
            return;
        }
        d.setCell(0, 0, "Volume").setCell(2, 0, t.getVolumeStr(8)).setCell(0, 1, "Pan").setCell(2, 1, t.getPanStr(8));
        int sendStart = 2;
        int sendCount = 6;
        if (((SLConfiguration)((SLControlSurface)this.surface).getConfiguration()).isDisplayCrossfader()) {
            sendStart = 3;
            sendCount = 5;
            String crossfadeMode = t.getCrossfadeMode();
            d.setCell(0, 2, "Crossfdr").setCell(2, 2, "A".equals(crossfadeMode) ? "A" : ("B".equals(crossfadeMode) ? "       B" : "   <> "));
        }
        if ((fxTrackBank = this.model.getEffectTrackBank()) != null) {
            boolean isFX = this.model.isEffectTrackBankActive();
            for (int i = 0; i < sendCount; ++i) {
                ITrack fxTrack = fxTrackBank.getTrack(i);
                boolean isEmpty = isFX || !fxTrack.doesExist();
                int pos = sendStart + i;
                d.setCell(0, pos, isEmpty ? "" : fxTrack.getName()).setCell(2, pos, isEmpty ? "" : t.getSend(i).getDisplayedValue(8));
            }
            if (isFX) {
                d.setCell(0, 7, t.getName());
            }
        } else {
            for (int i = 0; i < sendCount; ++i) {
                int pos = sendStart + i;
                ISend send = t.getSend(i);
                d.setCell(0, pos, send.getName(8)).setCell(2, pos, send.getDisplayedValue(8));
            }
        }
        d.done(0).done(2);
    }

    @Override
    public void onRowButton(int row, int index, ButtonEvent event) {
    }
}

