/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.sl.mode;

import de.mossgrabers.controller.sl.SLConfiguration;
import de.mossgrabers.controller.sl.controller.SLControlSurface;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ISceneBank;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.mode.AbstractMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class SessionMode
extends AbstractMode<SLControlSurface, SLConfiguration> {
    public SessionMode(SLControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
    }

    @Override
    public void updateDisplay() {
        Display d = ((SLControlSurface)this.surface).getDisplay();
        ISceneBank sceneBank = this.model.getSceneBank();
        for (int i = 0; i < 8; ++i) {
            IScene scene = sceneBank.getScene(i);
            String name = StringUtils.fixASCII(scene.getName());
            d.setCell(2, i, name.isEmpty() ? "Scene " + (i + 1) : name);
        }
        d.clearRow(0).done(0).done(2);
    }

    @Override
    public void onRowButton(int row, int index, ButtonEvent event) {
    }
}

