/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.sl.mode;

import de.mossgrabers.controller.sl.SLConfiguration;
import de.mossgrabers.controller.sl.controller.SLControlSurface;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.AbstractMode;
import de.mossgrabers.framework.utils.ButtonEvent;

public class FrameMode
extends AbstractMode<SLControlSurface, SLConfiguration> {
    private static final String[] COMMANDS = new String[]{"Arrange ", "  Mix   ", "  Edit  ", "NoteEdit", "Automate", " Device ", "  Mixer ", "   Full "};

    public FrameMode(SLControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
    }

    @Override
    public void onRowButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        switch (index) {
            case 0: {
                this.model.getApplication().setPanelLayout("ARRANGE");
                break;
            }
            case 1: {
                this.model.getApplication().setPanelLayout("MIX");
                break;
            }
            case 2: {
                this.model.getApplication().setPanelLayout("EDIT");
                break;
            }
            case 3: {
                this.model.getApplication().toggleNoteEditor();
                break;
            }
            case 4: {
                this.model.getApplication().toggleAutomationEditor();
                break;
            }
            case 5: {
                this.model.getApplication().toggleDevices();
                break;
            }
            case 6: {
                this.model.getApplication().toggleMixer();
                break;
            }
            case 7: {
                this.model.getApplication().toggleFullScreen();
            }
        }
    }

    @Override
    public void updateDisplay() {
        Display d = ((SLControlSurface)this.surface).getDisplay();
        d.clear().setBlock(0, 0, "Layouts:").setCell(0, 3, "Panels:");
        for (int i = 0; i < COMMANDS.length; ++i) {
            d.setCell(2, i, COMMANDS[i]);
        }
        d.done(0).done(2);
    }
}

