/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.sl.controller;

import de.mossgrabers.framework.controller.display.AbstractDisplay;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;

public class SLDisplay
extends AbstractDisplay {
    public static final String RIGHT_ARROW = ">";
    private static final String[] SPACES = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         "};

    public SLDisplay(IHost host, IMidiOutput output) {
        super(host, output, 4, 8, 8);
    }

    @Override
    public SLDisplay clearCell(int row, int cell) {
        this.cells[row * this.noOfCells + cell] = "         ";
        return this;
    }

    @Override
    public Display setBlock(int row, int block, String value) {
        int cell = 2 * block;
        if (value.length() > 9) {
            this.cells[row * 8 + cell] = value.substring(0, 9);
            this.cells[row * 8 + cell + 1] = SLDisplay.pad(value.substring(9), 8) + " ";
        } else {
            this.cells[row * 8 + cell] = SLDisplay.pad(value, 9);
            this.clearCell(row, cell + 1);
        }
        return this;
    }

    @Override
    public Display setCell(int row, int column, int value, Format format) {
        this.cells[row * this.noOfCells + column] = SLDisplay.pad(Integer.toString(value), 8) + " ";
        return this;
    }

    @Override
    public Display setCell(int row, int column, String value) {
        try {
            this.cells[row * this.noOfCells + column] = SLDisplay.pad(value, 8) + " ";
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.host.error("Display array index out of bounds.", ex);
        }
        return this;
    }

    @Override
    public void writeLine(int row, String text) {
        int length = text.length();
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = text.charAt(i);
        }
        this.output.sendSysex("F0 00 20 29 03 03 12 00 04 00 02 01 00 " + SLDisplay.uint7ToHex(row + 1) + "04 " + StringUtils.toHexStr(array) + "00 F7");
    }

    @Override
    public void shutdown() {
        this.notify("Please start " + this.host.getName() + " to play...");
    }

    private static String pad(String str, int length) {
        String text = str == null ? "" : str;
        int diff = length - text.length();
        if (diff < 0) {
            return text.substring(0, length);
        }
        if (diff > 0) {
            return text + SPACES[diff];
        }
        return text;
    }

    private static String uint7ToHex(int x) {
        int upper = x >> 4 & 7;
        int lower = x & 0xF;
        return Integer.toString(upper, 16) + Integer.toString(lower, 16) + " ";
    }
}

