/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.sl.command.trigger;

import de.mossgrabers.controller.sl.mode.Modes;
import de.mossgrabers.controller.sl.view.SLView;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.View;

public class ButtonRowSelectCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private int row;

    public ButtonRowSelectCommand(int row, IModel model, S surface) {
        super(model, surface);
        this.row = row;
    }

    @Override
    public void execute(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        View view = this.surface.getViewManager().getActiveView();
        if (view == null) {
            return;
        }
        switch (this.row) {
            case 0: {
                ((SLView)((Object)view)).onButtonRow1Select();
                break;
            }
            case 1: {
                this.surface.getModeManager().setActiveMode(Modes.MODE_PARAMS);
                this.surface.getDisplay().notify("Device Parameters");
                break;
            }
            case 2: {
                ((SLView)((Object)view)).onButtonRow2Select();
                break;
            }
            case 3: {
                this.onKnobRow2Select();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.onSliderRowSelect();
                break;
            }
            case 6: 
            case 7: {
                this.onSliderRowSelect();
                break;
            }
        }
    }

    private void onKnobRow2Select() {
        ModeManager modeManager = this.surface.getModeManager();
        if (modeManager.isActiveMode(Modes.MODE_MASTER)) {
            this.activateTrackMode(true, false);
            return;
        }
        if (modeManager.isActiveMode(Modes.MODE_TRACK)) {
            if (this.model.isEffectTrackBankActive()) {
                this.activateMasterMode(true);
            } else {
                this.activateTrackMode(true, true);
            }
            return;
        }
        this.activateTrackMode(true, this.model.isEffectTrackBankActive());
    }

    private void activateTrackMode(boolean activateMode, boolean isEffect) {
        boolean isEffectTrackBankActive = this.model.isEffectTrackBankActive();
        if (isEffect != isEffectTrackBankActive) {
            this.model.toggleCurrentTrackBank();
        }
        if (activateMode) {
            this.surface.getModeManager().setActiveMode(Modes.MODE_TRACK);
        }
        this.surface.getDisplay().notify(isEffect ? "Effects" : "Tracks");
        if (this.model.getSelectedTrack() == null) {
            this.selectTrack(0);
        }
    }

    private void activateMasterMode(boolean activateMode) {
        this.model.getMasterTrack().selectAndMakeVisible();
        if (activateMode) {
            this.surface.getModeManager().setActiveMode(Modes.MODE_MASTER);
        }
        this.surface.getDisplay().notify("Master");
    }

    private void onSliderRowSelect() {
        ModeManager modeManager = this.surface.getModeManager();
        if (!modeManager.isActiveMode(Modes.MODE_VOLUME)) {
            modeManager.setActiveMode(Modes.MODE_VOLUME);
            this.activateTrackMode(false, false);
            return;
        }
        if (this.model.getMasterTrack().isSelected()) {
            this.activateTrackMode(false, false);
        } else if (this.model.isEffectTrackBankActive()) {
            this.activateMasterMode(false);
        } else {
            this.activateTrackMode(false, true);
        }
    }
}

