/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.sl.command.continuous;

import de.mossgrabers.controller.sl.SLConfiguration;
import de.mossgrabers.controller.sl.controller.SLControlSurface;
import de.mossgrabers.controller.sl.mode.Modes;
import de.mossgrabers.framework.command.core.AbstractContinuousCommand;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.ModeManager;

public class TrackKnobRowCommand
extends AbstractContinuousCommand<SLControlSurface, SLConfiguration> {
    private int index;

    public TrackKnobRowCommand(int index, IModel model, SLControlSurface surface) {
        super(model, surface);
        this.index = index;
    }

    @Override
    public void execute(int value) {
        ModeManager modeManager = ((SLControlSurface)this.surface).getModeManager();
        Integer cm = modeManager.getActiveModeId();
        if (cm != Modes.MODE_TRACK && cm != Modes.MODE_MASTER) {
            modeManager.setActiveMode(Modes.MODE_TRACK);
            cm = Modes.MODE_TRACK;
        }
        if (cm == Modes.MODE_MASTER) {
            if (this.index == 0) {
                this.model.getMasterTrack().setVolume(value);
            } else if (this.index == 1) {
                this.model.getMasterTrack().setPan(value);
            }
            return;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack track = tb.getSelectedTrack();
        if (track == null) {
            return;
        }
        switch (this.index) {
            case 0: {
                track.setVolume(value);
                break;
            }
            case 1: {
                track.setPan(value);
                break;
            }
            case 2: {
                if (((SLConfiguration)((SLControlSurface)this.surface).getConfiguration()).isDisplayCrossfader()) {
                    track.setCrossfadeModeAsNumber(value == 0 ? 0 : (value == 127 ? 2 : 1));
                    break;
                }
                if (!(tb instanceof ITrackBank)) break;
                track.getSend(0).setValue(value);
                break;
            }
            default: {
                if (!(tb instanceof ITrackBank)) break;
                track.getSend(this.index - (((SLConfiguration)((SLControlSurface)this.surface).getConfiguration()).isDisplayCrossfader() ? 3 : 2)).setValue(value);
            }
        }
    }
}

