/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.sl.command.continuous;

import de.mossgrabers.controller.sl.SLConfiguration;
import de.mossgrabers.controller.sl.controller.SLControlSurface;
import de.mossgrabers.framework.command.core.AbstractContinuousCommand;
import de.mossgrabers.framework.daw.IModel;

public class TouchpadCommand
extends AbstractContinuousCommand<SLControlSurface, SLConfiguration> {
    private boolean isXDirection;

    public TouchpadCommand(boolean isXDirection, IModel model, SLControlSurface surface) {
        super(model, surface);
        this.isXDirection = isXDirection;
    }

    @Override
    public void execute(int value) {
        switch (((SLConfiguration)((SLControlSurface)this.surface).getConfiguration()).getTouchpadMode()) {
            case "Crossfader": {
                if (!this.isXDirection) break;
                this.model.getTransport().setCrossfade(value);
                break;
            }
            case "Remote Parameter 1&2": {
                this.model.getCursorDevice().setParameter(this.isXDirection ? 0 : 1, value);
            }
        }
    }
}

