/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.sl.command.continuous;

import de.mossgrabers.controller.sl.SLConfiguration;
import de.mossgrabers.controller.sl.controller.SLControlSurface;
import de.mossgrabers.controller.sl.mode.Modes;
import de.mossgrabers.framework.command.core.AbstractContinuousCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.ModeManager;

public class DeviceKnobRowCommand
extends AbstractContinuousCommand<SLControlSurface, SLConfiguration> {
    private int index;

    public DeviceKnobRowCommand(int index, IModel model, SLControlSurface surface) {
        super(model, surface);
        this.index = index;
    }

    @Override
    public void execute(int value) {
        if (!this.model.hasSelectedDevice()) {
            return;
        }
        int v = value > 64 ? 127 - (value - 64) : value;
        ModeManager modeManager = ((SLControlSurface)this.surface).getModeManager();
        if (!modeManager.isActiveMode(Modes.MODE_PARAMS)) {
            modeManager.setActiveMode(Modes.MODE_PARAMS);
        }
        modeManager.getMode(Modes.MODE_PARAMS).onValueKnob(this.index, v);
    }
}

