/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.sl;

import de.mossgrabers.controller.sl.SLConfiguration;
import de.mossgrabers.controller.sl.command.continuous.DeviceKnobRowCommand;
import de.mossgrabers.controller.sl.command.continuous.FaderCommand;
import de.mossgrabers.controller.sl.command.continuous.TapTempoInitMkICommand;
import de.mossgrabers.controller.sl.command.continuous.TapTempoMkICommand;
import de.mossgrabers.controller.sl.command.continuous.TouchpadCommand;
import de.mossgrabers.controller.sl.command.continuous.TrackKnobRowCommand;
import de.mossgrabers.controller.sl.command.trigger.ButtonRowSelectCommand;
import de.mossgrabers.controller.sl.command.trigger.ButtonRowViewCommand;
import de.mossgrabers.controller.sl.command.trigger.P1ButtonCommand;
import de.mossgrabers.controller.sl.command.trigger.P2ButtonCommand;
import de.mossgrabers.controller.sl.command.trigger.TransportButtonCommand;
import de.mossgrabers.controller.sl.controller.SLControlSurface;
import de.mossgrabers.controller.sl.controller.SLDisplay;
import de.mossgrabers.controller.sl.mode.FixedMode;
import de.mossgrabers.controller.sl.mode.FrameMode;
import de.mossgrabers.controller.sl.mode.FunctionMode;
import de.mossgrabers.controller.sl.mode.MasterMode;
import de.mossgrabers.controller.sl.mode.Modes;
import de.mossgrabers.controller.sl.mode.PlayOptionsMode;
import de.mossgrabers.controller.sl.mode.SessionMode;
import de.mossgrabers.controller.sl.mode.TrackMode;
import de.mossgrabers.controller.sl.mode.TrackTogglesMode;
import de.mossgrabers.controller.sl.mode.ViewSelectMode;
import de.mossgrabers.controller.sl.mode.VolumeMode;
import de.mossgrabers.controller.sl.mode.device.DeviceParamsMode;
import de.mossgrabers.controller.sl.mode.device.DevicePresetsMode;
import de.mossgrabers.controller.sl.view.ControlView;
import de.mossgrabers.controller.sl.view.PlayView;
import de.mossgrabers.controller.sl.view.Views;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.DefaultValueChanger;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.view.ViewManager;

public class SLControllerSetup
extends AbstractControllerSetup<SLControlSurface, SLConfiguration> {
    private static final int[] DRUM_MATRIX = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private final boolean isMkII;

    public SLControllerSetup(IHost host, ISetupFactory factory, ISettingsUI settings, boolean isMkII) {
        super(factory, host, settings);
        this.isMkII = isMkII;
        this.colorManager = new ColorManager();
        this.valueChanger = new DefaultValueChanger(128, 1, 0.5);
        this.configuration = new SLConfiguration(this.valueChanger, isMkII);
    }

    @Override
    public void flush() {
        this.flushSurfaces();
        this.updateIndication();
    }

    @Override
    protected void createScales() {
        this.scales = new Scales(this.valueChanger, 36, 52, 8, 2);
        this.scales.setDrumMatrix(DRUM_MATRIX);
        this.scales.setDrumNoteEnd(52);
    }

    @Override
    protected void createModel() {
        this.model = this.factory.createModel(this.colorManager, this.valueChanger, this.scales, 8, 8, 6, 16, 16, true, -1, -1, -1, -1);
        this.model.getTrackBank().addTrackSelectionObserver(this::handleTrackChange);
        this.model.getMasterTrack().addTrackSelectionObserver((index, isSelected) -> {
            if (!isSelected) {
                return;
            }
            ModeManager modeManager = ((SLControlSurface)this.getSurface()).getModeManager();
            if (!modeManager.isActiveMode(Modes.MODE_VOLUME)) {
                modeManager.setActiveMode(Modes.MODE_MASTER);
            }
        });
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput input = midiAccess.createInput(this.isMkII ? "Novation SL MkII (Drumpads)" : "Novation SL MkI (Drumpads)", "90????", "80????");
        midiAccess.createInput(1, this.isMkII ? "Novation SL MkII (Keyboard)" : "Novation SL MkI (Keyboard)", "80????", "90????", "B0????", "D0????", "E0????");
        IHost hostProxy = this.model.getHost();
        SLControlSurface surface = new SLControlSurface(hostProxy, this.colorManager, (SLConfiguration)this.configuration, output, input, this.isMkII);
        surface.setDisplay(new SLDisplay(hostProxy, output));
        this.surfaces.add(surface);
    }

    @Override
    protected void createObservers() {
        this.createScaleObservers(this.configuration);
    }

    @Override
    protected void createModes() {
        SLControlSurface surface = (SLControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.registerMode(Modes.MODE_FIXED, new FixedMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_FRAME, new FrameMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_FUNCTIONS, new FunctionMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_MASTER, new MasterMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_PLAY_OPTIONS, new PlayOptionsMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_SESSION, new SessionMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_TRACK, new TrackMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_TRACK_TOGGLES, new TrackTogglesMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_VIEW_SELECT, new ViewSelectMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_VOLUME, new VolumeMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_PARAMS, new DeviceParamsMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_BROWSER, new DevicePresetsMode(surface, this.model));
    }

    @Override
    protected void createViews() {
        SLControlSurface surface = (SLControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.registerView(Views.VIEW_PLAY, new PlayView(surface, this.model));
        viewManager.registerView(Views.VIEW_CONTROL, new ControlView(surface, this.model));
    }

    @Override
    protected void registerTriggerCommands() {
        SLControlSurface surface = (SLControlSurface)this.getSurface();
        for (int i = 0; i < 8; ++i) {
            this.addTriggerCommand(Commands.COMMAND_ROW1_1 + i, 24 + i, new ButtonRowViewCommand(0, i, this.model, surface));
            this.addTriggerCommand(Commands.COMMAND_ROW2_1 + i, 32 + i, new ButtonRowViewCommand(1, i, this.model, surface));
            this.addTriggerCommand(Commands.COMMAND_ROW3_1 + i, 40 + i, new ButtonRowViewCommand(2, i, this.model, surface));
            this.addTriggerCommand(Commands.COMMAND_ROW4_1 + i, 48 + i, new ButtonRowViewCommand(3, i, this.model, surface));
            this.addTriggerCommand(Commands.COMMAND_ROW_SELECT_1 + i, 80 + i, new ButtonRowSelectCommand(i, this.model, surface));
        }
        this.addTriggerCommand(Commands.COMMAND_REWIND, 72, new ButtonRowViewCommand(4, 0, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_FORWARD, 73, new ButtonRowViewCommand(4, 1, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_STOP, 74, new ButtonRowViewCommand(4, 2, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_PLAY, 75, new ButtonRowViewCommand(4, 3, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_LOOP, 77, new ButtonRowViewCommand(4, 4, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_RECORD, 76, new ButtonRowViewCommand(4, 6, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_LEFT, 88, new P1ButtonCommand(true, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_RIGHT, 89, new P1ButtonCommand(false, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_UP, 90, new P2ButtonCommand(true, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_DOWN, 91, new P2ButtonCommand(false, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SELECT_PLAY_VIEW, 79, new TransportButtonCommand(this.model, surface));
    }

    @Override
    protected void registerContinuousCommands() {
        SLControlSurface surface = (SLControlSurface)this.getSurface();
        for (int i = 0; i < 8; ++i) {
            this.addContinuousCommand(Commands.CONT_COMMAND_FADER1 + i, 16 + i, new FaderCommand(i, this.model, surface));
            this.addContinuousCommand(Commands.CONT_COMMAND_DEVICE_KNOB1 + i, 56 + i, new DeviceKnobRowCommand(i, this.model, surface));
            this.addContinuousCommand(Commands.CONT_COMMAND_KNOB1 + i, 8 + i, new TrackKnobRowCommand(i, this.model, surface));
        }
        this.addContinuousCommand(Commands.CONT_COMMAND_TOUCHPAD_X, 68, new TouchpadCommand(true, this.model, surface));
        this.addContinuousCommand(Commands.CONT_COMMAND_TOUCHPAD_Y, 69, new TouchpadCommand(false, this.model, surface));
        this.addContinuousCommand(Commands.CONT_COMMAND_TEMPO_TOUCH, 94, new TapTempoInitMkICommand(this.model, surface));
        this.addContinuousCommand(Commands.CONT_COMMAND_TEMPO, 95, new TapTempoMkICommand(this.model, surface));
    }

    @Override
    public void startup() {
        SLControlSurface surface = (SLControlSurface)this.getSurface();
        surface.getModeManager().getMode(Modes.MODE_VOLUME).updateDisplay();
        surface.getViewManager().setActiveView(Views.VIEW_CONTROL);
        surface.getModeManager().setActiveMode(Modes.MODE_TRACK);
    }

    private void updateIndication() {
        SLControlSurface surface = (SLControlSurface)this.getSurface();
        Integer mode = surface.getModeManager().getActiveModeId();
        IMasterTrack mt = this.model.getMasterTrack();
        mt.setVolumeIndication(Modes.MODE_MASTER.equals(mode));
        mt.setPanIndication(Modes.MODE_MASTER.equals(mode));
        ITrackBank tb = this.model.getTrackBank();
        IChannelBank tbe = this.model.getEffectTrackBank();
        boolean isEffect = this.model.isEffectTrackBankActive();
        boolean isVolume = Modes.MODE_VOLUME.equals(mode);
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        ITrack selectedTrack = tb.getSelectedTrack();
        for (int i = 0; i < 8; ++i) {
            boolean hasTrackSel = selectedTrack != null && selectedTrack.getIndex() == i && Modes.MODE_TRACK.equals(mode);
            ITrack track = tb.getTrack(i);
            track.setVolumeIndication(!isEffect && (isVolume || hasTrackSel));
            track.setPanIndication(!isEffect && hasTrackSel);
            for (int j = 0; j < 6; ++j) {
                track.getSend(j).setIndication(!isEffect && hasTrackSel);
            }
            if (tbe != null) {
                ITrack fxTrack = tbe.getTrack(i);
                fxTrack.setVolumeIndication(isEffect);
                fxTrack.setPanIndication(isEffect);
            }
            cursorDevice.indicateParameter(i, true);
        }
    }

    private void handleTrackChange(int index, boolean isSelected) {
        ModeManager modeManager = ((SLControlSurface)this.getSurface()).getModeManager();
        if (isSelected && modeManager.isActiveMode(Modes.MODE_MASTER)) {
            modeManager.setActiveMode(Modes.MODE_TRACK);
        }
    }
}

