/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.view;

import de.mossgrabers.framework.daw.IHost;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Views {
    public static final String VIEW_NAME_PLAY = "Play";
    public static final String VIEW_NAME_PIANO = "Piano";
    public static final String VIEW_NAME_DRUM = "Drum";
    public static final String VIEW_NAME_DRUM4 = "Drum 4";
    public static final String VIEW_NAME_DRUM8 = "Drum 8";
    public static final String VIEW_NAME_DRUM64 = "Drum 64";
    public static final String VIEW_NAME_SEQUENCER = "Sequencer";
    public static final String VIEW_NAME_RAINDROPS = "Raindrop";
    public static final Integer VIEW_PLAY = 0;
    public static final Integer VIEW_SESSION = 1;
    public static final Integer VIEW_SEQUENCER = 2;
    public static final Integer VIEW_DRUM = 3;
    public static final Integer VIEW_RAINDROPS = 4;
    public static final Integer VIEW_PIANO = 5;
    public static final Integer VIEW_PRG_CHANGE = 6;
    public static final Integer VIEW_CLIP = 7;
    public static final Integer VIEW_DRUM4 = 8;
    public static final Integer VIEW_DRUM8 = 9;
    public static final Integer VIEW_DRUM64 = 10;
    public static final Integer VIEW_COLOR = 11;
    public static final Integer VIEW_SCENE_PLAY = 12;
    private static final List<String> NOTE_VIEW_NAMES = new ArrayList<String>();
    private static final List<Integer> NOTE_VIEWS = new ArrayList<Integer>();
    private static final Set<Integer> SEQUENCER_VIEWS = new HashSet<Integer>();
    private static final Set<Integer> SESSION_VIEWS = new HashSet<Integer>();
    private static boolean isInitialised = false;

    private Views() {
    }

    public static void init(IHost host) {
        if (isInitialised) {
            return;
        }
        isInitialised = true;
        NOTE_VIEWS.add(VIEW_PLAY);
        NOTE_VIEWS.add(VIEW_PIANO);
        NOTE_VIEW_NAMES.add(VIEW_NAME_PLAY);
        NOTE_VIEW_NAMES.add(VIEW_NAME_PIANO);
        if (host.hasDrumDevice()) {
            NOTE_VIEWS.add(VIEW_DRUM);
            NOTE_VIEWS.add(VIEW_DRUM4);
            NOTE_VIEWS.add(VIEW_DRUM8);
            NOTE_VIEWS.add(VIEW_DRUM64);
            NOTE_VIEW_NAMES.add(VIEW_NAME_DRUM);
            NOTE_VIEW_NAMES.add(VIEW_NAME_DRUM4);
            NOTE_VIEW_NAMES.add(VIEW_NAME_DRUM8);
            NOTE_VIEW_NAMES.add(VIEW_NAME_DRUM64);
            SEQUENCER_VIEWS.add(VIEW_DRUM);
            SEQUENCER_VIEWS.add(VIEW_DRUM4);
            SEQUENCER_VIEWS.add(VIEW_DRUM8);
        }
        if (host.hasClips()) {
            NOTE_VIEWS.add(VIEW_SEQUENCER);
            NOTE_VIEWS.add(VIEW_RAINDROPS);
            NOTE_VIEW_NAMES.add(VIEW_NAME_SEQUENCER);
            NOTE_VIEW_NAMES.add(VIEW_NAME_RAINDROPS);
            SEQUENCER_VIEWS.add(VIEW_SEQUENCER);
            SEQUENCER_VIEWS.add(VIEW_RAINDROPS);
            SESSION_VIEWS.add(VIEW_SESSION);
            SESSION_VIEWS.add(VIEW_SCENE_PLAY);
        }
    }

    public static boolean isSequencerView(Integer viewId) {
        return SEQUENCER_VIEWS.contains(viewId);
    }

    public static boolean isSessionView(Integer viewId) {
        return SESSION_VIEWS.contains(viewId);
    }

    public static String[] getNoteViewNames() {
        return NOTE_VIEW_NAMES.toArray(new String[NOTE_VIEW_NAMES.size()]);
    }

    public static Integer getNoteView(int index) {
        return NOTE_VIEWS.get(index);
    }
}

