/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.view;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.command.trigger.SelectSessionViewCommand;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.controller.push.view.Views;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ISceneBank;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.view.AbstractSessionView;
import de.mossgrabers.framework.view.SessionColor;

public class SessionView
extends AbstractSessionView<PushControlSurface, PushConfiguration> {
    private static final int NUMBER_OF_RETRIES = 20;
    protected int startRetries;

    public SessionView(PushControlSurface surface, IModel model) {
        super("Session", surface, model, 8, 8, true);
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        int redLo = isPush2 ? 66 : 7;
        int redHi = isPush2 ? 127 : 5;
        int black = isPush2 ? 0 : 0;
        int green = isPush2 ? 83 : 22;
        int amber = isPush2 ? 65 : 10;
        SessionColor isRecording = new SessionColor(redHi, redHi, false);
        SessionColor isRecordingQueued = new SessionColor(redHi, black, true);
        SessionColor isPlaying = new SessionColor(green, green, false);
        SessionColor isPlayingQueued = new SessionColor(green, black, true);
        SessionColor hasContent = new SessionColor(amber, -1, false);
        SessionColor noContent = new SessionColor(black, -1, false);
        SessionColor recArmed = new SessionColor(redLo, -1, false);
        this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, hasContent, noContent, recArmed);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            TriggerCommand triggerCommand = ((PushControlSurface)this.surface).getViewManager().getView(Views.VIEW_SESSION).getTriggerCommand(Commands.COMMAND_SELECT_SESSION_VIEW);
            ((SelectSessionViewCommand)triggerCommand).setTemporary();
            return;
        }
        int index = note - 36;
        int t = index % this.columns;
        int s = this.rows - 1 - index / this.columns;
        boolean flipSession = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isFlipSession();
        if (flipSession) {
            int dummy = t;
            t = s;
            s = dummy;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            int numTracks = tb.getNumTracks();
            int numScenes = tb.getNumScenes();
            int trackPosition = tb.getTrack(0).getPosition() / numTracks;
            int scenePosition = tb.getScenePosition() / numScenes;
            int selX = flipSession ? scenePosition : trackPosition;
            int selY = flipSession ? trackPosition : scenePosition;
            int padsX = flipSession ? this.rows : this.columns;
            int padsY = flipSession ? this.columns : this.rows;
            int offsetX = selX / padsX * padsX;
            int offsetY = selY / padsY * padsY;
            tb.scrollToChannel(offsetX * numTracks + t * padsX);
            tb.scrollToScene(offsetY * numScenes + s * padsY);
            return;
        }
        ITrack track = tb.getTrack(t);
        if (((PushControlSurface)this.surface).isPressed(88)) {
            ((PushControlSurface)this.surface).setButtonConsumed(88);
            if (track.doesExist()) {
                track.getSlot(s).duplicate();
            }
            return;
        }
        if (((PushControlSurface)this.surface).isPressed(29)) {
            ((PushControlSurface)this.surface).setButtonConsumed(29);
            track.stop();
            return;
        }
        if (((PushControlSurface)this.surface).isPressed(111)) {
            ((PushControlSurface)this.surface).setButtonConsumed(111);
            if (!track.doesExist()) {
                return;
            }
            track.getSlot(s).browse();
            ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
            if (!modeManager.isActiveMode(Modes.MODE_BROWSER)) {
                this.activateMode();
            }
            return;
        }
        super.onGridNote(note, velocity);
    }

    protected void activateMode() {
        if (this.model.getBrowser().isActive()) {
            ((PushControlSurface)this.surface).getModeManager().setActiveMode(Modes.MODE_BROWSER);
        } else if (this.startRetries < 20) {
            ++this.startRetries;
            ((PushControlSurface)this.surface).scheduleTask(this::activateMode, 200L);
        }
    }

    @Override
    public void updateButtons() {
        ((PushControlSurface)this.surface).updateButton(55, "BUTTON_STATE_OFF");
        ((PushControlSurface)this.surface).updateButton(54, "BUTTON_STATE_OFF");
    }

    @Override
    public void updateSceneButtons() {
        ISceneBank sceneBank = this.model.getSceneBank();
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        int off = isPush2 ? 0 : 0;
        int green = isPush2 ? 83 : 19;
        for (int i = 0; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(36 + i, sceneBank.sceneExists(7 - i) ? green : off);
        }
    }

    @Override
    public boolean usesButton(int buttonID) {
        switch (buttonID) {
            case 54: 
            case 55: 
            case 56: {
                return false;
            }
        }
        return !((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2() || buttonID != 59;
    }
}

