/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.view;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.controller.push.mode.NoteMode;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractNoteSequencerView;

public class SequencerView
extends AbstractNoteSequencerView<PushControlSurface, PushConfiguration> {
    public SequencerView(PushControlSurface surface, IModel model) {
        super("Sequencer", surface, model, true);
    }

    @Override
    public boolean usesButton(int buttonID) {
        if (buttonID == 56) {
            return false;
        }
        return !((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2() || buttonID != 59;
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            if (event == ButtonEvent.DOWN) {
                this.getClip().transpose(-1);
            }
            return;
        }
        if (((PushControlSurface)this.surface).isSelectPressed()) {
            if (event == ButtonEvent.DOWN) {
                this.getClip().transpose(-12);
            }
            return;
        }
        super.onOctaveDown(event);
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            if (event == ButtonEvent.DOWN) {
                this.getClip().transpose(1);
            }
            return;
        }
        if (((PushControlSurface)this.surface).isSelectPressed()) {
            if (event == ButtonEvent.DOWN) {
                this.getClip().transpose(12);
            }
            return;
        }
        super.onOctaveUp(event);
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        ((PushControlSurface)this.surface).setGridNoteConsumed(note);
        int index = note - 36;
        int y = index / 8;
        if (y >= this.numSequencerRows) {
            return;
        }
        int x = index % 8;
        ICursorClip cursorClip = this.model.getCursorClip(8, 128);
        int state = cursorClip.getStep(x, this.noteMap[y]);
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        NoteMode noteMode = (NoteMode)modeManager.getMode(Modes.MODE_NOTE);
        noteMode.setValues(cursorClip, x, note, state == 2 ? 1.0 : 0.0, 127);
        modeManager.setActiveMode(Modes.MODE_NOTE);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int index = note - 36;
        int x = index % 8;
        int y = index / 8;
        if (y < this.numSequencerRows) {
            if (velocity == 0) {
                this.getClip().toggleStep(x, this.noteMap[y], this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : ((PushControlSurface)this.surface).getGridNoteVelocity(note));
            }
            return;
        }
        super.onGridNote(note, velocity);
    }

    @Override
    public void updateSceneButtons() {
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        int yellow = isPush2 ? 7 : 13;
        int green = isPush2 ? 83 : 19;
        for (int i = 36; i <= 43; ++i) {
            ((PushControlSurface)this.surface).updateButton(i, i == 36 + this.selectedIndex ? yellow : green);
        }
    }
}

