/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.view;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ISceneBank;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractView;
import de.mossgrabers.framework.view.SceneView;

public class ScenePlayView
extends AbstractView<PushControlSurface, PushConfiguration>
implements SceneView {
    private ITrackBank trackBank;

    public ScenePlayView(PushControlSurface surface, IModel model) {
        super("Scene Play", surface, model);
        this.trackBank = model.createSceneViewTrackBank(8, 64);
    }

    @Override
    public boolean usesButton(int buttonID) {
        switch (buttonID) {
            case 54: 
            case 55: 
            case 56: {
                return false;
            }
        }
        return !((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2() || buttonID != 59;
    }

    @Override
    public void drawGrid() {
        ISceneBank sceneBank = this.trackBank.getSceneBank();
        for (int i = 0; i < 64; ++i) {
            IScene scene = sceneBank.getScene(i);
            String color = scene.doesExist() ? this.trackBank.getColorOfFirstClipInScene(i) : "GRID_COLOR_OFF";
            ((PushControlSurface)this.surface).getPadGrid().light(36 + i, color);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity != 0) {
            this.trackBank.launchScene(note - 36);
        }
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
    }

    @Override
    public void updateSceneButtons() {
        int black = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2() ? 0 : 0;
        for (int i = 0; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(36 + i, black);
        }
    }
}

