/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.view;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractRaindropsView;

public class RaindropsView
extends AbstractRaindropsView<PushControlSurface, PushConfiguration> {
    public RaindropsView(PushControlSurface surface, IModel model) {
        super("Raindrop", surface, model, true);
    }

    @Override
    public boolean usesButton(int buttonID) {
        if (buttonID == 56) {
            return false;
        }
        return !((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2() || buttonID != 59;
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            this.getClip().transpose(-1);
            return;
        }
        if (((PushControlSurface)this.surface).isSelectPressed()) {
            this.getClip().transpose(-12);
            return;
        }
        super.onOctaveDown(event);
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            this.getClip().transpose(1);
            return;
        }
        if (((PushControlSurface)this.surface).isSelectPressed()) {
            this.getClip().transpose(12);
            return;
        }
        super.onOctaveUp(event);
    }

    @Override
    public void updateSceneButtons() {
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        int yellow = isPush2 ? 7 : 13;
        int green = isPush2 ? 83 : 19;
        for (int i = 36; i <= 43; ++i) {
            ((PushControlSurface)this.surface).updateButton(i, i == 36 + this.selectedIndex ? yellow : green);
        }
    }
}

