/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.view;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractView;
import de.mossgrabers.framework.view.SceneView;

public class PrgChangeView
extends AbstractView<PushControlSurface, PushConfiguration>
implements SceneView {
    private int[] greens;
    private int[] yellows;
    private int bankNumber = 0;
    private int programNumber = -1;
    private boolean isToggled = false;

    public PrgChangeView(PushControlSurface surface, IModel model) {
        super("PrgChnge", surface, model);
        boolean isPush2 = ((PushConfiguration)surface.getConfiguration()).isPush2();
        int greenHi = isPush2 ? 126 : 21;
        int green = isPush2 ? 83 : 22;
        int greenLo = isPush2 ? 10 : 23;
        int greenSpring = isPush2 ? 8 : 24;
        this.greens = new int[]{greenHi, green, greenLo, greenSpring, greenHi, green, greenLo, greenSpring};
        int yellowHi = isPush2 ? 7 : 13;
        int yellow = isPush2 ? 7 : 14;
        int yellowLo = isPush2 ? 75 : 15;
        int yellowLime = isPush2 ? 77 : 16;
        this.yellows = new int[]{yellowHi, yellow, yellowLo, yellowLime, yellowHi, yellow, yellowLo, yellowLime};
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.noteMap = Scales.getEmptyMatrix();
        ((PushControlSurface)this.surface).setKeyTranslationTable(this.noteMap);
    }

    @Override
    public boolean usesButton(int buttonID) {
        switch (buttonID) {
            case 54: 
            case 55: 
            case 56: {
                return false;
            }
        }
        return !((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2() || buttonID != 59;
    }

    @Override
    public void onScene(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        int newBank = index;
        if (newBank == this.bankNumber) {
            this.isToggled = !this.isToggled;
        } else {
            this.bankNumber = newBank;
            this.isToggled = false;
            ((PushControlSurface)this.surface).sendMidiEvent(176, 32, this.bankNumber);
            if (this.programNumber != -1) {
                ((PushControlSurface)this.surface).sendMidiEvent(192, this.programNumber, 0);
            }
        }
    }

    @Override
    public void updateSceneButtons() {
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        int green = isPush2 ? 83 : 19;
        int yellow = isPush2 ? 7 : 13;
        int black = isPush2 ? 0 : 0;
        for (int i = 0; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(36 + i, this.bankNumber == 7 - i ? (this.isToggled ? yellow : green) : black);
        }
    }

    @Override
    public void drawGrid() {
        int[] colors;
        int[] nArray = colors = this.isToggled ? this.yellows : this.greens;
        int selPad = this.isToggled ? (this.programNumber >= 64 ? this.programNumber - 64 : -1) : (this.programNumber < 64 ? this.programNumber : -1);
        PadGrid gridPad = ((PushControlSurface)this.surface).getPadGrid();
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        int red = isPush2 ? 127 : 6;
        for (int i = 36; i < 100; ++i) {
            int pad = i - 36;
            int row = pad / 8;
            gridPad.light(i, selPad == pad ? red : colors[row], -1, false);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        this.programNumber = note - 36 + (this.isToggled ? 64 : 0);
        ((PushControlSurface)this.surface).sendMidiEvent(192, this.programNumber, 0);
    }

    @Override
    public void updateArrows() {
        ((PushControlSurface)this.surface).updateButton(55, "BUTTON_STATE_OFF");
        ((PushControlSurface)this.surface).updateButton(54, "BUTTON_STATE_OFF");
    }
}

