/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.view;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ISceneBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractPlayView;
import de.mossgrabers.framework.view.SceneView;
import java.util.Arrays;

public class PlayView
extends AbstractPlayView<PushControlSurface, PushConfiguration>
implements SceneView {
    public PlayView(PushControlSurface surface, IModel model) {
        this("Play", surface, model);
    }

    public PlayView(String name, PushControlSurface surface, IModel model) {
        super(name, surface, model, true);
        Object configuration = ((PushControlSurface)this.surface).getConfiguration();
        configuration.addSettingObserver(AbstractConfiguration.ACTIVATE_FIXED_ACCENT, this::initMaxVelocity);
        configuration.addSettingObserver(AbstractConfiguration.FIXED_ACCENT_VALUE, this::initMaxVelocity);
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.initMaxVelocity();
    }

    @Override
    public boolean usesButton(int buttonID) {
        if (buttonID == 56) {
            return false;
        }
        return !((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2() || buttonID != 59;
    }

    @Override
    public void updateButtons() {
        int octave = this.scales.getOctave();
        ((PushControlSurface)this.surface).updateButton(55, octave < 4 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
        ((PushControlSurface)this.surface).updateButton(54, octave > -4 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
    }

    private void initMaxVelocity() {
        int[] maxVelocity = new int[128];
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        Arrays.fill(maxVelocity, config.getFixedAccentValue());
        maxVelocity[0] = 0;
        ((PushControlSurface)this.surface).setVelocityTranslationTable(config.isAccentActive() ? maxVelocity : this.defaultVelocity);
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.model.getCurrentTrackBank().launchScene(scene);
        }
    }

    @Override
    public void updateSceneButtons() {
        ISceneBank sceneBank = this.model.getSceneBank();
        if (sceneBank == null) {
            return;
        }
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        int off = isPush2 ? 0 : 0;
        int green = isPush2 ? 83 : 19;
        for (int i = 0; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(36 + i, sceneBank.sceneExists(7 - i) ? green : off);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setButtonConsumed(((PushControlSurface)this.surface).getDeleteButtonId());
            this.model.getCursorClip().clearRow(this.noteMap[note]);
            return;
        }
        super.onGridNote(note, velocity);
    }
}

