/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.view;

import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.view.PlayView;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;

public class PianoView
extends PlayView {
    public PianoView(PushControlSurface surface, IModel model) {
        super("Piano", surface, model);
    }

    @Override
    public void drawGrid() {
        PadGrid gridPad = ((PushControlSurface)this.surface).getPadGrid();
        if (!this.model.canSelectedTrackHoldNotes()) {
            gridPad.turnOff();
            return;
        }
        ColorManager colorManager = this.model.getColorManager();
        boolean isRecording = this.model.hasRecordingState();
        ITrack track = this.model.getSelectedTrack();
        int playKeyColor = colorManager.getColor(isRecording ? "PLAY_VIEW_COLOR_RECORD" : "PLAY_VIEW_COLOR_PLAY");
        int whiteKeyColor = colorManager.getColor("SCALE_COLOR_NOTE");
        int blackKeyColor = colorManager.getColor(PianoView.replaceOctaveColorWithTrackColor(track, "SCALE_COLOR_OCTAVE"));
        int offKeyColor = colorManager.getColor("SCALE_COLOR_OFF");
        for (int i = 0; i < 8; ++i) {
            int n;
            int j;
            if (i % 2 == 0) {
                for (j = 0; j < 8; ++j) {
                    gridPad.light(n, this.pressedKeys[n = 36 + 8 * i + j] > 0 ? playKeyColor : whiteKeyColor, -1, false);
                }
                continue;
            }
            for (j = 0; j < 8; ++j) {
                n = 36 + 8 * i + j;
                if (j == 0 || j == 3 || j == 7) {
                    gridPad.light(n, offKeyColor, -1, false);
                    continue;
                }
                gridPad.light(n, this.pressedKeys[n] > 0 ? playKeyColor : blackKeyColor, -1, false);
            }
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes() || this.noteMap[note] == -1) {
            return;
        }
        for (int i = 0; i < 128; ++i) {
            if (this.noteMap[note] != this.noteMap[i]) continue;
            this.pressedKeys[i] = velocity;
        }
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.clearPressedKeys();
        this.scales.decPianoOctave();
        this.updateNoteMapping();
        ((PushControlSurface)this.surface).getDisplay().notify(this.scales.getPianoRangeText(), true, true);
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.clearPressedKeys();
        this.scales.incPianoOctave();
        this.updateNoteMapping();
        ((PushControlSurface)this.surface).getDisplay().notify(this.scales.getPianoRangeText(), true, true);
    }

    @Override
    public void updateNoteMapping() {
        ((PushControlSurface)this.surface).scheduleTask(this::delayedUpdateNoteMapping, 100L);
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        int octave = this.scales.getPianoOctave();
        ((PushControlSurface)this.surface).updateButton(55, octave < 3 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
        ((PushControlSurface)this.surface).updateButton(54, octave > -3 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
    }

    private void delayedUpdateNoteMapping() {
        this.noteMap = this.model.canSelectedTrackHoldNotes() ? this.scales.getPianoMatrix() : Scales.getEmptyMatrix();
        ((PushControlSurface)this.surface).setKeyTranslationTable(this.noteMap);
    }
}

