/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.view;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractDrumView;

public abstract class DrumViewBase
extends AbstractDrumView<PushControlSurface, PushConfiguration> {
    protected int soundOffset;

    public DrumViewBase(String name, PushControlSurface surface, IModel model, int numSequencerLines, int numPlayLines) {
        super(name, surface, model, numSequencerLines, numPlayLines);
    }

    @Override
    public boolean usesButton(int buttonID) {
        if (buttonID == 56) {
            return false;
        }
        return !((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2() || buttonID != 59;
    }

    @Override
    public void onScene(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN || !this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        if (!((PushControlSurface)this.surface).isShiftPressed()) {
            super.onScene(index, event);
            return;
        }
        ITrack selectedTrack = this.model.getSelectedTrack();
        if (selectedTrack != null) {
            this.onLowerScene(index);
        }
    }

    protected void onLowerScene(int index) {
    }

    @Override
    public void updateButtons() {
        int octave = this.scales.getDrumOctave();
        ((PushControlSurface)this.surface).updateButton(55, octave < 4 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
        ((PushControlSurface)this.surface).updateButton(54, octave > -2 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
    }

    @Override
    public void updateSceneButtons() {
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            int off = isPush2 ? 0 : 0;
            for (int i = 4; i < 8; ++i) {
                ((PushControlSurface)this.surface).updateButton(((PushControlSurface)this.surface).getSceneButton(i), off);
            }
            this.updateLowerSceneButtons();
            return;
        }
        int yellow = isPush2 ? 7 : 13;
        int green = isPush2 ? 83 : 19;
        for (int i = 36; i <= 43; ++i) {
            ((PushControlSurface)this.surface).updateButton(i, i == 36 + this.selectedIndex ? yellow : green);
        }
    }

    protected void updateLowerSceneButtons() {
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        int off = isPush2 ? 0 : 0;
        for (int i = 0; i < 4; ++i) {
            ((PushControlSurface)this.surface).updateButton(((PushControlSurface)this.surface).getSceneButton(i), off);
        }
    }
}

