/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.view;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.view.DrumViewBase;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.scale.Scales;

public class DrumView8
extends DrumViewBase {
    private static final int NUM_DISPLAY_COLS = 8;

    public DrumView8(PushControlSurface surface, IModel model) {
        super("Drum 8", surface, model, 1, 0);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes() || velocity == 0) {
            return;
        }
        int index = note - 36;
        int x = index % 8;
        int y = index / 8;
        int sound = y + this.soundOffset;
        int col = x;
        this.getClip().toggleStep(col, this.offsetY + this.selectedPad + sound, this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : velocity);
    }

    @Override
    public void drawGrid() {
        if (!this.model.canSelectedTrackHoldNotes()) {
            ((PushControlSurface)this.surface).getPadGrid().turnOff();
            return;
        }
        int step = this.getClip().getCurrentStep();
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        int blueHi = isPush2 ? 95 : 45;
        int greenLo = isPush2 ? 10 : 23;
        int greenHi = isPush2 ? 126 : 21;
        int off = isPush2 ? 0 : 0;
        int hiStep = this.isInXRange(step) ? step % 8 : -1;
        for (int sound = 0; sound < 8; ++sound) {
            for (int col = 0; col < 8; ++col) {
                int isSet = this.getClip().getStep(col, this.offsetY + this.selectedPad + sound + this.soundOffset);
                boolean hilite = col == hiStep;
                int x = col % 8;
                int y = col / 8;
                ((PushControlSurface)this.surface).getPadGrid().lightEx(x, 7 - (y += sound), isSet > 0 ? (hilite ? greenLo : blueHi) : (hilite ? greenHi : off), -1, false);
            }
        }
    }

    @Override
    public void updateNoteMapping() {
        ((PushControlSurface)this.surface).setKeyTranslationTable(this.scales.translateMatrixToGrid(Scales.getEmptyMatrix()));
    }

    @Override
    public void updateButtons() {
        ((PushControlSurface)this.surface).updateButton(55, "BUTTON_STATE_ON");
        ((PushControlSurface)this.surface).updateButton(54, "BUTTON_STATE_ON");
    }

    @Override
    protected void updateLowerSceneButtons() {
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        int yellow = isPush2 ? 7 : 13;
        int green = isPush2 ? 83 : 19;
        int off = isPush2 ? 0 : 0;
        ((PushControlSurface)this.surface).updateButton(36, this.soundOffset == 0 ? yellow : green);
        ((PushControlSurface)this.surface).updateButton(37, this.soundOffset == 8 ? yellow : green);
        ((PushControlSurface)this.surface).updateButton(38, off);
        ((PushControlSurface)this.surface).updateButton(39, off);
    }

    @Override
    protected void onLowerScene(int index) {
        if (index < 6) {
            return;
        }
        this.soundOffset = index == 7 ? 0 : 8;
        ((PushControlSurface)this.surface).getDisplay().notify("Offset: " + this.soundOffset);
    }
}

