/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.view;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.view.AbstractDrumView64;

public class DrumView64
extends AbstractDrumView64<PushControlSurface, PushConfiguration> {
    public DrumView64(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void updateButtons() {
        ((PushControlSurface)this.surface).updateButton(55, this.drumOctave < 1 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
        ((PushControlSurface)this.surface).updateButton(54, this.drumOctave > -2 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
    }

    @Override
    protected void handleDeleteButton(int playedPad) {
        ((PushControlSurface)this.surface).setButtonConsumed(((PushControlSurface)this.surface).getDeleteButtonId());
        this.model.getCursorClip().clearRow(this.offsetY + playedPad);
    }

    @Override
    protected void handleSelectButton(int playedPad) {
        ICursorDevice drumDevice64 = this.model.getDrumDevice64();
        if (!drumDevice64.hasDrumPads()) {
            return;
        }
        if (drumDevice64.getDrumPad(playedPad).isSelected()) {
            return;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        if (cd.isNested()) {
            cd.selectParent();
        }
        ((PushControlSurface)this.surface).getModeManager().setActiveMode(Modes.MODE_DEVICE_LAYER);
        drumDevice64.selectDrumPad(playedPad);
    }

    @Override
    public void updateSceneButtons() {
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        int off = isPush2 ? 0 : 0;
        for (int i = 36; i <= 43; ++i) {
            ((PushControlSurface)this.surface).updateButton(i, off);
        }
    }
}

