/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.view;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.view.DrumViewBase;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.scale.Scales;

public class DrumView4
extends DrumViewBase {
    private static final int NUM_DISPLAY_COLS = 16;

    public DrumView4(PushControlSurface surface, IModel model) {
        super("Drum 4", surface, model, 2, 0);
        this.soundOffset = 0;
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes() || velocity == 0) {
            return;
        }
        int index = note - 36;
        int x = index % 8;
        int y = index / 8;
        int sound = y % 4 + this.soundOffset;
        int col = 8 * (1 - y / 4) + x;
        this.getClip().toggleStep(col, this.offsetY + this.selectedPad + sound, this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : velocity);
    }

    @Override
    public void drawGrid() {
        if (!this.model.canSelectedTrackHoldNotes()) {
            ((PushControlSurface)this.surface).getPadGrid().turnOff();
            return;
        }
        ICursorClip clip = this.getClip();
        int step = clip.getCurrentStep();
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        int blueHi = isPush2 ? 95 : 45;
        int greenLo = isPush2 ? 10 : 23;
        int greenHi = isPush2 ? 126 : 21;
        int off = isPush2 ? 0 : 0;
        int hiStep = this.isInXRange(step) ? step % 16 : -1;
        for (int sound = 0; sound < 4; ++sound) {
            for (int col = 0; col < 16; ++col) {
                int isSet = clip.getStep(col, this.offsetY + this.selectedPad + sound + this.soundOffset);
                boolean hilite = col == hiStep;
                int x = col % 8;
                int y = col / 8;
                if (col < 8) {
                    y += 5;
                }
                ((PushControlSurface)this.surface).getPadGrid().lightEx(x, 8 - (y += sound), isSet > 0 ? (hilite ? greenLo : blueHi) : (hilite ? greenHi : off), -1, false);
            }
        }
    }

    @Override
    public void updateNoteMapping() {
        ((PushControlSurface)this.surface).setKeyTranslationTable(this.scales.translateMatrixToGrid(Scales.getEmptyMatrix()));
    }

    @Override
    public void updateButtons() {
        ((PushControlSurface)this.surface).updateButton(55, "BUTTON_STATE_ON");
        ((PushControlSurface)this.surface).updateButton(54, "BUTTON_STATE_ON");
    }

    @Override
    protected void onLowerScene(int index) {
        this.soundOffset = 4 * (7 - index);
        ((PushControlSurface)this.surface).getDisplay().notify("Offset: " + this.soundOffset);
    }

    @Override
    protected void updateLowerSceneButtons() {
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        int yellow = isPush2 ? 7 : 13;
        int green = isPush2 ? 83 : 19;
        ((PushControlSurface)this.surface).updateButton(36, this.soundOffset == 0 ? yellow : green);
        ((PushControlSurface)this.surface).updateButton(37, this.soundOffset == 4 ? yellow : green);
        ((PushControlSurface)this.surface).updateButton(38, this.soundOffset == 8 ? yellow : green);
        ((PushControlSurface)this.surface).updateButton(39, this.soundOffset == 12 ? yellow : green);
    }
}

