/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.view;

import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.controller.push.view.DrumViewBase;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IDrumPad;

public class DrumView
extends DrumViewBase {
    private static final int NUMBER_OF_RETRIES = 20;
    protected int startRetries;

    public DrumView(PushControlSurface surface, IModel model) {
        super("Drum", surface, model, 4, 4);
    }

    @Override
    protected void handleButtonCombinations(int playedPad) {
        if (((PushControlSurface)this.surface).isPressed(111)) {
            ((PushControlSurface)this.surface).setButtonConsumed(111);
            ICursorDevice primary = this.model.getPrimaryDevice();
            if (!primary.hasDrumPads()) {
                return;
            }
            IDrumPad drumPad = primary.getDrumPad(playedPad);
            drumPad.browseToInsert();
            this.activateMode();
            return;
        }
        super.handleButtonCombinations(playedPad);
    }

    @Override
    public void handleSelectButton(int playedPad) {
        ICursorDevice primary = this.model.getPrimaryDevice();
        if (!primary.hasDrumPads()) {
            return;
        }
        if (primary.getDrumPad(playedPad).isSelected()) {
            return;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        if (cd.isNested()) {
            cd.selectParent();
        }
        ((PushControlSurface)this.surface).getModeManager().setActiveMode(Modes.MODE_DEVICE_LAYER);
        primary.selectDrumPad(playedPad);
        this.updateNoteMapping();
    }

    protected void activateMode() {
        if (this.model.getBrowser().isActive()) {
            ((PushControlSurface)this.surface).getModeManager().setActiveMode(Modes.MODE_BROWSER);
        } else if (this.startRetries < 20) {
            ++this.startRetries;
            ((PushControlSurface)this.surface).scheduleTask(this::activateMode, 200L);
        }
    }
}

