/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.view;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.framework.daw.DAWColors;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractView;
import de.mossgrabers.framework.view.SceneView;

public class ColorView
extends AbstractView<PushControlSurface, PushConfiguration>
implements SceneView {
    private SelectMode mode = SelectMode.MODE_TRACK;

    public ColorView(PushControlSurface surface, IModel model) {
        super("Color", surface, model);
    }

    public void setMode(SelectMode mode) {
        this.mode = mode;
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.noteMap = Scales.getEmptyMatrix();
        ((PushControlSurface)this.surface).setKeyTranslationTable(this.noteMap);
    }

    @Override
    public boolean usesButton(int buttonID) {
        switch (buttonID) {
            case 54: 
            case 55: 
            case 56: {
                return false;
            }
        }
        return !((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2() || buttonID != 59;
    }

    @Override
    public void drawGrid() {
        for (int i = 0; i < 64; ++i) {
            ((PushControlSurface)this.surface).getPadGrid().light(36 + i, i < DAWColors.DAW_COLORS.length ? DAWColors.DAW_COLORS[i] : "GRID_COLOR_OFF");
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        int color = note - 36;
        if (color < DAWColors.DAW_COLORS.length) {
            double[] entry = DAWColors.getColorEntry(DAWColors.DAW_COLORS[color]);
            switch (this.mode) {
                case MODE_TRACK: {
                    ITrack t = this.model.getSelectedTrack();
                    if (t == null) {
                        IMasterTrack master = this.model.getMasterTrack();
                        if (!master.isSelected()) break;
                        master.setColor(entry[0], entry[1], entry[2]);
                        break;
                    }
                    t.setColor(entry[0], entry[1], entry[2]);
                    break;
                }
                case MODE_LAYER: {
                    ICursorDevice cd = this.model.getCursorDevice();
                    IChannel deviceChain = cd.getSelectedLayerOrDrumPad();
                    cd.setLayerOrDrumPadColor(deviceChain.getIndex(), entry[0], entry[1], entry[2]);
                    break;
                }
                case MODE_CLIP: {
                    ICursorClip clip = this.model.getCursorClip();
                    if (clip == null) break;
                    clip.setColor(entry[0], entry[1], entry[2]);
                }
            }
        }
        ((PushControlSurface)this.surface).getViewManager().restoreView();
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
    }

    @Override
    public void updateSceneButtons() {
        int black = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2() ? 0 : 0;
        for (int i = 0; i < 8; ++i) {
            ((PushControlSurface)this.surface).updateButton(36 + i, black);
        }
    }

    public static enum SelectMode {
        MODE_TRACK,
        MODE_LAYER,
        MODE_CLIP;

    }
}

