/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.view;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractSequencerView;

public class ClipView
extends AbstractSequencerView<PushControlSurface, PushConfiguration> {
    private int loopPadPressed = -1;
    private int[] padResolutions = new int[]{1, 4, 16};
    private int padResolution = 0;

    public ClipView(PushControlSurface surface, IModel model) {
        super("Clip", surface, model, 0, 0);
    }

    @Override
    public void updateNoteMapping() {
        this.noteMap = Scales.getEmptyMatrix();
        ((PushControlSurface)this.surface).setKeyTranslationTable(this.noteMap);
    }

    @Override
    public boolean usesButton(int buttonID) {
        switch (buttonID) {
            case 54: 
            case 55: 
            case 56: {
                return false;
            }
        }
        return !((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2() || buttonID != 59;
    }

    @Override
    public void onGridNote(int note, int velocity) {
        int index = note - 36;
        int x = index % 8;
        int y = index / 8;
        int pad = (7 - y) * 8 + x;
        if (velocity > 0) {
            if (this.loopPadPressed == -1) {
                this.loopPadPressed = pad;
            }
        } else if (this.loopPadPressed != -1) {
            int start = this.loopPadPressed < pad ? this.loopPadPressed : pad;
            int end = (this.loopPadPressed < pad ? pad : this.loopPadPressed) + 1;
            double quartersPerPad = this.getQuartersPerPad();
            double newStart = (double)start * quartersPerPad;
            ICursorClip clip = this.model.getCursorClip();
            clip.setLoopStart(newStart);
            clip.setLoopLength((int)((double)(end - start) * quartersPerPad));
            clip.setPlayRange(newStart, (double)end * quartersPerPad);
            this.loopPadPressed = -1;
        }
    }

    @Override
    public void drawGrid() {
        ICursorClip clip = this.model.getCursorClip();
        int step = clip.getCurrentStep();
        double quartersPerPad = this.getQuartersPerPad();
        int stepsPerMeasure = (int)Math.round(quartersPerPad / RESOLUTIONS[this.selectedIndex]);
        int currentMeasure = step / stepsPerMeasure;
        double maxQuarters = quartersPerPad * 64.0;
        double start = clip.getLoopStart();
        int loopStartPad = (int)Math.floor(Math.max(0.0, start) / quartersPerPad);
        int loopEndPad = (int)Math.ceil(Math.min(maxQuarters, start + clip.getLoopLength()) / quartersPerPad);
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        int white = isPush2 ? 120 : 3;
        int green = isPush2 ? 83 : 22;
        int off = isPush2 ? 0 : 0;
        for (int pad = 0; pad < 64; ++pad) {
            ((PushControlSurface)this.surface).getPadGrid().lightEx(pad % 8, pad / 8, pad >= loopStartPad && pad < loopEndPad ? (pad == currentMeasure ? green : white) : off, -1, false);
        }
    }

    @Override
    public void onScene(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        int res = 7 - index;
        if (res <= 3) {
            this.padResolution = res;
        }
    }

    @Override
    public void updateSceneButtons() {
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPush2();
        int yellow = isPush2 ? 7 : 13;
        int green = isPush2 ? 83 : 19;
        int off = isPush2 ? 0 : 0;
        for (int i = 0; i < 8; ++i) {
            if (i < 3) {
                ((PushControlSurface)this.surface).updateButton(36 + i, i == this.padResolution ? yellow : green);
                continue;
            }
            ((PushControlSurface)this.surface).updateButton(36 + i, off);
        }
    }

    @Override
    public void updateButtons() {
        ((PushControlSurface)this.surface).updateButton(55, "BUTTON_STATE_OFF");
        ((PushControlSurface)this.surface).updateButton(54, "BUTTON_STATE_OFF");
    }

    private double getQuartersPerPad() {
        return (double)this.model.getTransport().getQuartersPerMeasure() / (double)this.padResolutions[this.padResolution];
    }
}

